/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.internal.Actions;
import org.gradle.internal.InternalBuildAdapter;

public class BuildSrcBuildListenerFactory {
    private final Action<ProjectInternal> buildSrcRootProjectConfiguration;

    public BuildSrcBuildListenerFactory() {
        this(Actions.doNothing());
    }

    public BuildSrcBuildListenerFactory(Action<ProjectInternal> buildSrcRootProjectConfiguration) {
        this.buildSrcRootProjectConfiguration = buildSrcRootProjectConfiguration;
    }

    Listener create() {
        return new Listener(this.buildSrcRootProjectConfiguration);
    }

    public static class Listener
    extends InternalBuildAdapter
    implements ModelConfigurationListener {
        private Set<File> classpath;
        private final Action<ProjectInternal> rootProjectConfiguration;

        private Listener(Action<ProjectInternal> rootProjectConfiguration) {
            this.rootProjectConfiguration = rootProjectConfiguration;
        }

        @Override
        public void projectsLoaded(Gradle gradle) {
            this.rootProjectConfiguration.execute((ProjectInternal)gradle.getRootProject());
        }

        @Override
        public void onConfigure(GradleInternal gradle) {
            BuildableJavaComponent mainComponent = this.mainComponentOf(gradle);
            gradle.getStartParameter().setTaskNames(mainComponent.getBuildTasks());
            this.classpath = mainComponent.getRuntimeClasspath().getFiles();
        }

        public Collection<File> getRuntimeClasspath() {
            return this.classpath;
        }

        private BuildableJavaComponent mainComponentOf(GradleInternal gradle) {
            return gradle.getRootProject().getServices().get(ComponentRegistry.class).getMainComponent();
        }
    }
}

