/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.VersionSpecificCacheCleanupAction;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public class ProjectCacheDir
implements Stoppable {
    private static final long MAX_UNUSED_DAYS_FOR_RELEASES_AND_SNAPSHOTS = 7L;
    private final File dir;
    private final ProgressLoggerFactory progressLoggerFactory;

    public ProjectCacheDir(File dir, ProgressLoggerFactory progressLoggerFactory) {
        this.dir = dir;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public File getDir() {
        return this.dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        VersionSpecificCacheCleanupAction cleanupAction = new VersionSpecificCacheCleanupAction(this.dir, 7L);
        String description = cleanupAction.getDisplayName();
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(ProjectCacheDir.class).start(description, description);
        try {
            cleanupAction.execute(new DefaultCleanupProgressMonitor(progressLogger));
        }
        finally {
            progressLogger.completed();
        }
    }
}

