/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import org.gradle.api.Action;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.InternalListener;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public abstract class ImmutableActionSet<T>
implements Action<T>,
InternalListener {
    private static final int FEW_VALUES = 5;
    private static final ImmutableActionSet<Object> EMPTY = new EmptySet<Object>();

    public static <T> ImmutableActionSet<T> empty() {
        return (ImmutableActionSet)Cast.uncheckedCast(EMPTY);
    }

    public static <T> ImmutableActionSet<T> of(Action<? super T> ... actions) {
        if (actions.length == 0) {
            return ImmutableActionSet.empty();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Action<? super T> action : actions) {
            if (action == Actions.DO_NOTHING || action instanceof EmptySet) continue;
            ImmutableActionSet.unpackAction(action, builder);
        }
        ImmutableSet set = builder.build();
        return ImmutableActionSet.fromActions(set);
    }

    private static <T> void unpackAction(Action<? super T> action, ImmutableSet.Builder<Action<? super T>> builder) {
        if (action instanceof ImmutableActionSet) {
            ImmutableActionSet immutableSet = (ImmutableActionSet)action;
            immutableSet.unpackInto(builder);
        } else {
            builder.add(action);
        }
    }

    protected abstract void unpackInto(ImmutableSet.Builder<Action<? super T>> var1);

    public ImmutableActionSet<T> add(Action<? super T> action) {
        if (action == Actions.DO_NOTHING || action instanceof EmptySet || action == this) {
            return this;
        }
        if (action instanceof SingletonSet) {
            SingletonSet singletonSet = (SingletonSet)action;
            return this.addOne(singletonSet.singleAction);
        }
        if (action instanceof SetWithFewActions) {
            SetWithFewActions compositeSet = (SetWithFewActions)action;
            return this.addAll(compositeSet);
        }
        if (action instanceof SetWithManyActions) {
            SetWithManyActions compositeSet = (SetWithManyActions)action;
            return this.addAll(compositeSet);
        }
        return this.addOne(action);
    }

    private static <T> ImmutableActionSet<T> plus(ImmutableActionSet<T> one, ImmutableActionSet<T> two) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        one.unpackInto(builder);
        two.unpackInto(builder);
        ImmutableSet set = builder.build();
        return ImmutableActionSet.fromActions(set);
    }

    private static <T> ImmutableActionSet<T> plus(ImmutableActionSet<T> one, Action<? super T> two) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        one.unpackInto(builder);
        builder.add(two);
        ImmutableSet set = builder.build();
        return ImmutableActionSet.fromActions(set);
    }

    private static <T> ImmutableActionSet<T> fromActions(ImmutableSet<Action<? super T>> set) {
        if (set.isEmpty()) {
            return ImmutableActionSet.empty();
        }
        if (set.size() == 1) {
            return new SingletonSet((Action)set.iterator().next());
        }
        if (set.size() <= 5) {
            return new SetWithFewActions<T>(set);
        }
        return new SetWithManyActions<T>(set);
    }

    public ImmutableActionSet<T> mergeFrom(ImmutableActionSet<? super T> sibling) {
        if (sibling == this) {
            return this;
        }
        if (sibling.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return sibling;
        }
        return this.add(sibling);
    }

    public abstract boolean isEmpty();

    abstract ImmutableActionSet<T> addAll(SetWithFewActions<T> var1);

    abstract ImmutableActionSet<T> addAll(SetWithManyActions<T> var1);

    abstract ImmutableActionSet<T> addOne(Action<? super T> var1);

    private static class SetWithManyActions<T>
    extends ImmutableActionSet<T> {
        private final ImmutableSet<Action<? super T>> multipleActions;

        SetWithManyActions(ImmutableSet<Action<? super T>> multipleActions) {
            this.multipleActions = multipleActions;
        }

        @Override
        ImmutableActionSet<T> addOne(Action<? super T> action) {
            return ImmutableActionSet.plus((ImmutableActionSet)this, action);
        }

        @Override
        ImmutableActionSet<T> addAll(SetWithManyActions<T> source) {
            return ImmutableActionSet.plus((ImmutableActionSet)this, (ImmutableActionSet)source);
        }

        @Override
        ImmutableActionSet<T> addAll(SetWithFewActions<T> source) {
            return ImmutableActionSet.plus((ImmutableActionSet)this, (ImmutableActionSet)source);
        }

        @Override
        protected void unpackInto(ImmutableSet.Builder<Action<? super T>> builder) {
            builder.addAll(this.multipleActions);
        }

        @Override
        public void execute(T t) {
            for (Action action : this.multipleActions) {
                action.execute(t);
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static class SetWithFewActions<T>
    extends ImmutableActionSet<T> {
        private final Action<? super T>[] actions;

        SetWithFewActions(ImmutableSet<Action<? super T>> set) {
            this.actions = (Action[])set.toArray((Object[])new Action[set.size()]);
        }

        SetWithFewActions(Action<? super T>[] actions) {
            this.actions = actions;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        ImmutableActionSet<T> addOne(Action<? super T> action) {
            if (this.contains(action)) {
                return this;
            }
            if (this.actions.length < 5) {
                Action[] newActions = new Action[this.actions.length + 1];
                System.arraycopy(this.actions, 0, newActions, 0, this.actions.length);
                newActions[this.actions.length] = action;
                return new SetWithFewActions<T>(newActions);
            }
            return ImmutableActionSet.plus((ImmutableActionSet)this, action);
        }

        @Override
        ImmutableActionSet<T> addAll(SetWithFewActions<T> source) {
            return ImmutableActionSet.plus((ImmutableActionSet)this, (ImmutableActionSet)source);
        }

        @Override
        ImmutableActionSet<T> addAll(SetWithManyActions<T> source) {
            return ImmutableActionSet.plus((ImmutableActionSet)this, (ImmutableActionSet)source);
        }

        @Override
        protected void unpackInto(ImmutableSet.Builder<Action<? super T>> builder) {
            builder.add((Object[])this.actions);
        }

        @Override
        public void execute(T t) {
            for (Action<T> action : this.actions) {
                action.execute(t);
            }
        }

        public boolean contains(Action<? super T> action) {
            for (Action<T> action2 : this.actions) {
                if (!action2.equals(action)) continue;
                return true;
            }
            return false;
        }
    }

    private static class SingletonSet<T>
    extends ImmutableActionSet<T> {
        private final Action<? super T> singleAction;

        SingletonSet(Action<? super T> singleAction) {
            this.singleAction = singleAction;
        }

        @Override
        ImmutableActionSet<T> addOne(Action<? super T> action) {
            if (action.equals(this.singleAction)) {
                return this;
            }
            return new SetWithFewActions(new Action[]{this.singleAction, action});
        }

        @Override
        ImmutableActionSet<T> addAll(SetWithFewActions<T> source) {
            if (this.singleAction.equals(((SetWithFewActions)source).actions[0])) {
                return source;
            }
            if (((SetWithFewActions)source).actions.length < 5 && !source.contains(this.singleAction)) {
                Action[] newActions = new Action[((SetWithFewActions)source).actions.length + 1];
                newActions[0] = this.singleAction;
                System.arraycopy(((SetWithFewActions)source).actions, 0, newActions, 1, ((SetWithFewActions)source).actions.length);
                return new SetWithFewActions(newActions);
            }
            return ImmutableActionSet.plus((ImmutableActionSet)this, (ImmutableActionSet)source);
        }

        @Override
        ImmutableActionSet<T> addAll(SetWithManyActions<T> source) {
            return ImmutableActionSet.plus((ImmutableActionSet)this, (ImmutableActionSet)source);
        }

        @Override
        protected void unpackInto(ImmutableSet.Builder<Action<? super T>> builder) {
            builder.add(this.singleAction);
        }

        @Override
        public void execute(T t) {
            this.singleAction.execute(t);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static class EmptySet<T>
    extends ImmutableActionSet<T> {
        private EmptySet() {
        }

        @Override
        ImmutableActionSet<T> addOne(Action<? super T> action) {
            return new SingletonSet<T>(action);
        }

        @Override
        ImmutableActionSet<T> addAll(SetWithManyActions<T> source) {
            return source;
        }

        @Override
        ImmutableActionSet<T> addAll(SetWithFewActions<T> source) {
            return source;
        }

        @Override
        protected void unpackInto(ImmutableSet.Builder<Action<? super T>> builder) {
        }

        @Override
        public void execute(Object o) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

