/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.FingerprintCompareStrategy;

public class ClasspathCompareStrategy
implements FingerprintCompareStrategy.Impl {
    @Override
    public boolean visitChangesSince(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> currentSnapshots, Map<String, NormalizedFileSnapshot> previousSnapshots, String propertyTitle, boolean includeAdded) {
        block5: {
            Iterator<Map.Entry<String, NormalizedFileSnapshot>> currentEntries = currentSnapshots.entrySet().iterator();
            Iterator<Map.Entry<String, NormalizedFileSnapshot>> previousEntries = previousSnapshots.entrySet().iterator();
            while (true) {
                if (currentEntries.hasNext()) {
                    Map.Entry<String, NormalizedFileSnapshot> current = currentEntries.next();
                    String currentAbsolutePath = current.getKey();
                    if (previousEntries.hasNext()) {
                        String previousNormalizedPath;
                        Map.Entry<String, NormalizedFileSnapshot> previous = previousEntries.next();
                        NormalizedFileSnapshot currentNormalizedSnapshot = current.getValue();
                        NormalizedFileSnapshot previousNormalizedSnapshot = previous.getValue();
                        String currentNormalizedPath = currentNormalizedSnapshot.getNormalizedPath();
                        if (currentNormalizedPath.equals(previousNormalizedPath = previousNormalizedSnapshot.getNormalizedPath())) {
                            if (currentNormalizedSnapshot.getNormalizedContentHash().equals(previousNormalizedSnapshot.getNormalizedContentHash()) || visitor.visitChange(FileChange.modified(currentAbsolutePath, propertyTitle, previousNormalizedSnapshot.getType(), currentNormalizedSnapshot.getType()))) continue;
                            return false;
                        }
                        String previousAbsolutePath = previous.getKey();
                        if (!visitor.visitChange(FileChange.removed(previousAbsolutePath, propertyTitle, previousNormalizedSnapshot.getType()))) {
                            return false;
                        }
                        if (!includeAdded || visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, currentNormalizedSnapshot.getType()))) continue;
                        return false;
                    }
                    if (!includeAdded || visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, current.getValue().getType()))) continue;
                    return false;
                }
                if (!previousEntries.hasNext()) break block5;
                Map.Entry<String, NormalizedFileSnapshot> previousEntry = previousEntries.next();
                if (!visitor.visitChange(FileChange.removed(previousEntry.getKey(), propertyTitle, previousEntry.getValue().getType()))) break;
            }
            return false;
        }
        return true;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        for (NormalizedFileSnapshot normalizedSnapshot : snapshots) {
            normalizedSnapshot.appendToHasher(hasher);
        }
    }
}

