/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.impldep.com.google.common.collect.BiMap;
import org.gradle.internal.impldep.com.google.common.collect.HashBiMap;
import org.gradle.internal.logging.LoggingConfigurationBuildOptions;

public class LoggingCommandLineConverter
extends AbstractCommandLineConverter<LoggingConfiguration> {
    private final List<BuildOption<LoggingConfiguration>> buildOptions = LoggingConfigurationBuildOptions.get();
    public static final String DEBUG = "d";
    public static final String WARN = "w";
    public static final String INFO = "i";
    public static final String QUIET = "q";
    private final BiMap<String, LogLevel> logLevelMap = HashBiMap.create();

    public LoggingCommandLineConverter() {
        this.logLevelMap.put((Object)QUIET, (Object)LogLevel.QUIET);
        this.logLevelMap.put((Object)WARN, (Object)LogLevel.WARN);
        this.logLevelMap.put((Object)INFO, (Object)LogLevel.INFO);
        this.logLevelMap.put((Object)DEBUG, (Object)LogLevel.DEBUG);
    }

    @Override
    public LoggingConfiguration convert(ParsedCommandLine commandLine, LoggingConfiguration loggingConfiguration) throws CommandLineArgumentException {
        for (BuildOption<LoggingConfiguration> option : this.buildOptions) {
            option.applyFromCommandLine(commandLine, loggingConfiguration);
        }
        return loggingConfiguration;
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (BuildOption<LoggingConfiguration> option : this.buildOptions) {
            option.configure(parser);
        }
    }

    public Set<LogLevel> getLogLevels() {
        return new HashSet<LogLevel>(Arrays.asList(LogLevel.DEBUG, LogLevel.INFO, LogLevel.LIFECYCLE, LogLevel.QUIET, LogLevel.WARN));
    }

    public Set<String> getLogLevelOptions() {
        return this.logLevelMap.keySet();
    }
}

