/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import org.gradle.internal.logging.console.AbstractUserInputRenderer;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.events.OutputEventListener;

public class UserInputConsoleRenderer
extends AbstractUserInputRenderer {
    private final Console console;

    public UserInputConsoleRenderer(OutputEventListener delegate, Console console) {
        super(delegate);
        this.console = console;
    }

    @Override
    void startInput(String prompt) {
        this.toggleBuildProgressAreaVisibility(false);
        this.printToBuildProgressArea(prompt);
        this.flushConsole();
    }

    @Override
    void finishInput() {
        this.toggleBuildProgressAreaVisibility(true);
        this.flushConsole();
    }

    private void toggleBuildProgressAreaVisibility(boolean visible) {
        this.console.getBuildProgressArea().setVisible(visible);
    }

    private void printToBuildProgressArea(String message) {
        this.console.getBuildOutputArea().println(message);
    }

    private void flushConsole() {
        this.console.flush();
    }
}

