/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.net.URI;
import java.util.Set;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceAccessor;
import org.gradle.internal.resource.BasicTextResourceLoader;
import org.gradle.internal.resource.DownloadedUriTextResource;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class DefaultUriTextResourceLoader
extends BasicTextResourceLoader {
    private final ExternalResourceAccessor externalResourceAccessor;
    private final Set<String> cachedSchemes;

    public DefaultUriTextResourceLoader(ExternalResourceAccessor externalResourceAccessor, Set<String> cachedSchemes) {
        this.externalResourceAccessor = externalResourceAccessor;
        this.cachedSchemes = cachedSchemes;
    }

    @Override
    public TextResource loadUri(String description, URI source) {
        if (this.isCacheable(source)) {
            LocallyAvailableExternalResource resource = this.externalResourceAccessor.resolveUri(source);
            if (resource == null) {
                throw ResourceExceptions.getMissing(source);
            }
            ExternalResourceMetaData metaData = resource.getMetaData();
            String contentType = metaData == null ? null : metaData.getContentType();
            return new DownloadedUriTextResource(description, source, contentType, resource.getFile());
        }
        return super.loadUri(description, source);
    }

    private boolean isCacheable(URI source) {
        return this.isCacheableScheme(source) && this.isCacheableResource(source);
    }

    private boolean isCacheableScheme(URI source) {
        return this.cachedSchemes.contains(source.getScheme());
    }

    private boolean isCacheableResource(URI source) {
        return source.getRawQuery() == null;
    }
}

