/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import java.net.URI;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.internal.impldep.com.jcraft.jsch.SftpATTRS;
import org.gradle.internal.impldep.com.jcraft.jsch.SftpException;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpResource;

public class SftpResourceAccessor
implements ExternalResourceAccessor {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceAccessor(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    @Override
    public ExternalResourceMetaData getMetaData(URI uri, boolean revalidate) {
        LockableSftpClient sftpClient = this.sftpClientFactory.createSftpClient(uri, this.credentials);
        try {
            SftpATTRS attributes = sftpClient.getSftpClient().lstat(uri.getPath());
            ExternalResourceMetaData externalResourceMetaData = attributes != null ? this.toMetaData(uri, attributes) : null;
            return externalResourceMetaData;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                ExternalResourceMetaData externalResourceMetaData = null;
                return externalResourceMetaData;
            }
            throw ResourceExceptions.getFailed(uri, e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(sftpClient);
        }
    }

    private ExternalResourceMetaData toMetaData(URI uri, SftpATTRS attributes) {
        long lastModified = -1L;
        long contentLength = -1L;
        if ((attributes.getFlags() & 8) != 0) {
            lastModified = attributes.getMTime() * 1000;
        }
        if ((attributes.getFlags() & 1) != 0) {
            contentLength = attributes.getSize();
        }
        return new DefaultExternalResourceMetaData(uri, lastModified, contentLength);
    }

    @Override
    public ExternalResourceReadResponse openResource(URI location, boolean revalidate) {
        ExternalResourceMetaData metaData = this.getMetaData(location, revalidate);
        return metaData != null ? new SftpResource(this.sftpClientFactory, metaData, location, this.credentials) : null;
    }
}

