/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionValidationException;
import org.gradle.internal.rules.RuleActionValidator;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

public class DefaultRuleActionValidator
implements RuleActionValidator {
    private static final String VALID_SINGLE_TYPES = "Rule may not have an input parameter of type: %s. Second parameter must be of type: %s.";
    private static final String VALID_MULTIPLE_TYPES = "Rule may not have an input parameter of type: %s. Valid types (for the second and subsequent parameters) are: %s.";
    private final List<Class<?>> validInputTypes;

    public DefaultRuleActionValidator(List<Class<?>> validInputTypes) {
        this.validInputTypes = validInputTypes;
    }

    @Override
    public <T> RuleAction<? super T> validate(RuleAction<? super T> ruleAction) {
        this.validateInputTypes(ruleAction);
        return ruleAction;
    }

    private void validateInputTypes(RuleAction<?> ruleAction) {
        for (Class<?> inputType : ruleAction.getInputTypes()) {
            if (this.validInputTypes.contains(inputType)) continue;
            throw new RuleActionValidationException(this.invalidParameterMessage(inputType));
        }
    }

    private String invalidParameterMessage(Class<?> inputType) {
        if (this.validInputTypes.size() == 1) {
            return String.format(VALID_SINGLE_TYPES, inputType.getName(), DefaultRuleActionValidator.className(this.validInputTypes.get(0)));
        }
        return String.format(VALID_MULTIPLE_TYPES, inputType.getName(), CollectionUtils.collect(this.validInputTypes, new ClassNameTransformer()));
    }

    private static String className(Class<?> aClass) {
        return ModelType.of(aClass).toString();
    }

    private static class ClassNameTransformer
    implements Transformer<String, Class<?>> {
        private ClassNameTransformer() {
        }

        @Override
        public String transform(Class<?> aClass) {
            return DefaultRuleActionValidator.className(aClass);
        }
    }
}

