/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;

public class DefaultGradleUserHomeScopeServiceRegistry
implements GradleUserHomeScopeServiceRegistry,
Closeable {
    public static final String REUSE_USER_HOME_SERVICES = "org.gradle.internal.reuse.user.home.services";
    private final ServiceRegistry sharedServices;
    private final Object provider;
    private final Lock lock = new ReentrantLock();
    private final Map<File, Services> servicesForHomeDir = new HashMap<File, Services>();

    public DefaultGradleUserHomeScopeServiceRegistry(ServiceRegistry sharedServices, Object provider) {
        this.sharedServices = sharedServices;
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CompositeStoppable stoppable = new CompositeStoppable();
        this.lock.lock();
        try {
            for (Map.Entry<File, Services> entry : this.servicesForHomeDir.entrySet()) {
                Services services = entry.getValue();
                if (services.count != 0) {
                    throw new IllegalStateException("Services for Gradle user home directory '" + entry.getKey() + "' have not been released.");
                }
                stoppable.add((Object)services.registry);
            }
            this.servicesForHomeDir.clear();
        }
        finally {
            this.lock.unlock();
        }
        stoppable.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRegistry getServicesFor(final File gradleUserHomeDir) {
        this.lock.lock();
        try {
            Services services = this.servicesForHomeDir.get(gradleUserHomeDir);
            if (services == null) {
                Services otherServices;
                if (this.servicesForHomeDir.size() == 1 && (otherServices = this.servicesForHomeDir.values().iterator().next()).count == 0) {
                    CompositeStoppable.stoppable(otherServices.registry).stop();
                    this.servicesForHomeDir.clear();
                }
                ServiceRegistry userHomeServices = ServiceRegistryBuilder.builder().parent(this.sharedServices).displayName("services for Gradle user home dir " + gradleUserHomeDir).provider(new Object(){

                    GradleUserHomeDirProvider createGradleUserHomeDirProvider() {
                        return new GradleUserHomeDirProvider(){

                            @Override
                            public File getGradleUserHomeDirectory() {
                                return gradleUserHomeDir;
                            }
                        };
                    }
                }).provider(this.provider).build();
                services = new Services(userHomeServices);
                this.servicesForHomeDir.put(gradleUserHomeDir, services);
            }
            services.count++;
            ServiceRegistry serviceRegistry = services.registry;
            return serviceRegistry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ServiceRegistry registry) {
        this.lock.lock();
        try {
            for (Map.Entry<File, Services> entry : this.servicesForHomeDir.entrySet()) {
                Services services = entry.getValue();
                if (services.registry != registry) continue;
                if (services.count <= 0) {
                    break;
                }
                services.count--;
                if (services.count == 0 && (this.servicesForHomeDir.size() > 1 || System.getProperty(REUSE_USER_HOME_SERVICES, "true").equals("false"))) {
                    CompositeStoppable.stoppable(services.registry).stop();
                    this.servicesForHomeDir.remove(entry.getKey());
                }
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        throw new IllegalStateException("Gradle user home directory scoped services have already been released.");
    }

    private static class Services {
        private final ServiceRegistry registry;
        private int count;

        public Services(ServiceRegistry registry) {
            this.registry = registry;
        }
    }
}

