/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.nativeplatform.internal.AbstractBinaryToolSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

public abstract class AbstractNativeCompileSpec
extends AbstractBinaryToolSpec
implements NativeCompileSpec {
    private List<File> includeRoots = new ArrayList<File>();
    private List<File> systemIncludeRoots = new ArrayList<File>();
    private List<File> sourceFiles = new ArrayList<File>();
    private List<File> removedSourceFiles = new ArrayList<File>();
    private boolean incrementalCompile;
    private Map<String, String> macros = new LinkedHashMap<String, String>();
    private File objectFileDir;
    private boolean positionIndependentCode;
    private boolean debuggable;
    private boolean optimized;
    private BuildOperationLogger oplogger;
    private File prefixHeaderFile;
    private File preCompiledHeaderObjectFile;
    private List<File> sourceFilesForPch = new ArrayList<File>();
    private String preCompiledHeader;

    @Override
    public List<File> getIncludeRoots() {
        return this.includeRoots;
    }

    @Override
    public void include(File ... includeRoots) {
        Collections.addAll(this.includeRoots, includeRoots);
    }

    @Override
    public void include(Iterable<File> includeRoots) {
        this.addAll(this.includeRoots, includeRoots);
    }

    @Override
    public List<File> getSystemIncludeRoots() {
        return this.systemIncludeRoots;
    }

    @Override
    public void systemInclude(Iterable<File> systemIncludeRoots) {
        this.addAll(this.systemIncludeRoots, systemIncludeRoots);
    }

    @Override
    public List<File> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public void source(Iterable<File> sources) {
        this.addAll(this.sourceFiles, sources);
    }

    @Override
    public void setSourceFiles(Collection<File> sources) {
        this.sourceFiles.clear();
        this.sourceFiles.addAll(sources);
    }

    @Override
    public List<File> getRemovedSourceFiles() {
        return this.removedSourceFiles;
    }

    @Override
    public void removedSource(Iterable<File> sources) {
        this.addAll(this.removedSourceFiles, sources);
    }

    @Override
    public void setRemovedSourceFiles(Collection<File> sources) {
        this.removedSourceFiles.clear();
        this.removedSourceFiles.addAll(sources);
    }

    @Override
    public boolean isIncrementalCompile() {
        return this.incrementalCompile;
    }

    @Override
    public void setIncrementalCompile(boolean flag) {
        this.incrementalCompile = flag;
    }

    @Override
    public File getObjectFileDir() {
        return this.objectFileDir;
    }

    @Override
    public void setObjectFileDir(File objectFileDir) {
        this.objectFileDir = objectFileDir;
    }

    @Override
    public Map<String, String> getMacros() {
        return this.macros;
    }

    @Override
    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    @Override
    public void define(String name) {
        this.macros.put(name, null);
    }

    @Override
    public void define(String name, String value) {
        this.macros.put(name, value);
    }

    @Override
    public boolean isPositionIndependentCode() {
        return this.positionIndependentCode;
    }

    @Override
    public void setPositionIndependentCode(boolean positionIndependentCode) {
        this.positionIndependentCode = positionIndependentCode;
    }

    @Override
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Override
    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Override
    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    @Override
    public File getPreCompiledHeaderObjectFile() {
        return this.preCompiledHeaderObjectFile;
    }

    @Override
    public void setPreCompiledHeaderObjectFile(File preCompiledHeaderObjectFile) {
        this.preCompiledHeaderObjectFile = preCompiledHeaderObjectFile;
    }

    @Override
    public File getPrefixHeaderFile() {
        return this.prefixHeaderFile;
    }

    @Override
    public void setPrefixHeaderFile(File pchFile) {
        this.prefixHeaderFile = pchFile;
    }

    @Override
    public String getPreCompiledHeader() {
        return this.preCompiledHeader;
    }

    @Override
    public void setPreCompiledHeader(String preCompiledHeader) {
        this.preCompiledHeader = preCompiledHeader;
    }

    private void addAll(List<File> list, Iterable<File> iterable) {
        for (File file : iterable) {
            list.add(file);
        }
    }

    @Override
    public BuildOperationLogger getOperationLogger() {
        return this.oplogger;
    }

    @Override
    public void setOperationLogger(BuildOperationLogger oplogger) {
        this.oplogger = oplogger;
    }

    @Override
    public List<File> getSourceFilesForPch() {
        return this.sourceFilesForPch;
    }

    @Override
    public void setSourceFilesForPch(List<File> sourceFilesForPch) {
        this.sourceFilesForPch = sourceFilesForPch;
    }
}

