/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal.toolchain;

import org.gradle.api.GradleException;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.util.TreeVisitor;

public class NotFoundScalaToolProvider
implements ToolProvider {
    private Exception exception;

    public NotFoundScalaToolProvider(Exception moduleVersionNotFoundException) {
        this.exception = moduleVersionNotFoundException;
    }

    @Override
    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
        throw this.failure();
    }

    @Override
    public <T> T get(Class<T> toolType) {
        throw this.failure();
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    private RuntimeException failure() {
        TreeFormatter formatter = new TreeFormatter();
        this.explain(formatter);
        return new GradleException(formatter.toString(), this.exception);
    }

    @Override
    public void explain(TreeVisitor<? super String> visitor) {
        visitor.node("Cannot provide Scala Compiler");
        visitor.startChildren();
        visitor.node(this.exception.getCause().getMessage());
        visitor.endChildren();
    }
}

