/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.net.jcip.annotations.NotThreadSafe;
import org.gradle.model.ConfigurationCycleException;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.EmptyModelProjection;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelSpec;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.inspect.ExtractedRuleSource;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelElementNode;
import org.gradle.model.internal.registry.ModelGraph;
import org.gradle.model.internal.registry.ModelListener;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.ModelPathSuggestionProvider;
import org.gradle.model.internal.registry.ModelReferenceNode;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.ModelRegistryInternal;
import org.gradle.model.internal.registry.NodeAtState;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.registry.RuleBindings;
import org.gradle.model.internal.registry.RuleContext;
import org.gradle.model.internal.registry.UnboundModelRulesException;
import org.gradle.model.internal.registry.UnboundRulesProcessor;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultModelRegistry
implements ModelRegistryInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModelRegistry.class);
    private final String projectPath;
    private final ModelGraph modelGraph;
    private final RuleBindings ruleBindings;
    private final ModelRuleExtractor ruleExtractor;
    private final List<RuleBinder> unboundRules = new LinkedList<RuleBinder>();

    public DefaultModelRegistry(ModelRuleExtractor ruleExtractor, String projectPath) {
        this.ruleExtractor = ruleExtractor;
        this.projectPath = projectPath;
        ModelRegistration rootRegistration = ModelRegistrations.of(ModelPath.ROOT).descriptor("<root>").withProjection(EmptyModelProjection.INSTANCE).build();
        this.modelGraph = new ModelGraph(new ModelElementNode(this, rootRegistration, null));
        this.ruleBindings = new RuleBindings();
        this.transition(this.modelGraph.getRoot(), ModelNode.State.Created, false);
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public DefaultModelRegistry register(ModelRegistration registration) {
        ModelPath path = registration.getPath();
        if (!ModelPath.ROOT.isDirectChild(path)) {
            throw new InvalidModelRuleDeclarationException(registration.getDescriptor(), "Cannot register element at '" + path + "', only top level is allowed (e.g. '" + path.getRootParent() + "')");
        }
        ModelNodeInternal root = this.modelGraph.getRoot();
        root.addLink(registration);
        return this;
    }

    @Override
    public void registerNode(ModelNodeInternal node, Multimap<ModelActionRole, ? extends ModelAction> actions) {
        LOGGER.debug("Project {} - Registering model element '{}' (hidden = {})", new Object[]{this.projectPath, node.getPath(), node.isHidden()});
        this.addRuleBindings(node, actions);
        this.modelGraph.add(node);
        this.ruleBindings.nodeCreated(node);
    }

    private void addRuleBindings(ModelNodeInternal node, Multimap<ModelActionRole, ? extends ModelAction> actions) {
        for (Map.Entry entry : actions.entries()) {
            ModelActionRole role = (ModelActionRole)((Object)entry.getKey());
            ModelAction action = (ModelAction)entry.getValue();
            DefaultModelRegistry.checkNodePath(node, action);
            RuleBinder binder = this.bindInternal(action.getSubject(), role, action);
            node.addRegistrationActionBinder(binder);
        }
    }

    @Override
    public DefaultModelRegistry configure(ModelActionRole role, ModelAction action) {
        this.bindInternal(action.getSubject(), role, action);
        return this;
    }

    @Override
    public ModelRegistry configureMatching(final ModelSpec spec, final ModelActionRole role, final ModelAction action) {
        if (action.getSubject().getPath() != null) {
            throw new IllegalArgumentException("Linked element action reference must have null path.");
        }
        final ModelType<?> subjectType = action.getSubject().getType();
        this.registerListener(new DelegatingListener(spec){

            public String toString() {
                return "configure matching " + spec + " using " + action.getDescriptor();
            }

            @Override
            public void onDiscovered(ModelNodeInternal node) {
                if (node.canBeViewedAs(subjectType) && spec.matches(node)) {
                    DefaultModelRegistry.this.bind(ModelReference.of(node.getPath(), subjectType), role, action);
                }
            }
        });
        return this;
    }

    @Override
    public ModelRegistry configureMatching(final ModelSpec predicate, final Class<? extends RuleSource> rules) {
        this.registerListener(new DelegatingListener(predicate){

            public String toString() {
                return "configure matching " + predicate + " apply " + rules.getSimpleName();
            }

            @Override
            public void onDiscovered(ModelNodeInternal node) {
                if (predicate.matches(node)) {
                    node.applyToSelf(rules);
                }
            }
        });
        return this;
    }

    @Override
    public ExtractedRuleSource<?> newRuleSource(Class<? extends RuleSource> rules) {
        return this.ruleExtractor.extract(rules);
    }

    static void checkNodePath(ModelNodeInternal node, ModelAction action) {
        if (!node.getPath().equals(action.getSubject().getPath())) {
            throw new IllegalArgumentException(String.format("Element action reference has path (%s) which does not reference this node (%s).", action.getSubject().getPath(), node.getPath()));
        }
    }

    @Override
    public <T> void bind(ModelReference<T> subject, ModelActionRole role, ModelAction mutator) {
        this.bindInternal(subject, role, mutator);
    }

    private <T> RuleBinder bindInternal(ModelReference<T> subject, ModelActionRole role, ModelAction mutator) {
        BindingPredicate mappedSubject = this.mapSubject(subject, role);
        List<BindingPredicate> mappedInputs = this.mapInputs(mutator.getInputs());
        RuleBinder binder = new RuleBinder(mappedSubject, mappedInputs, mutator, this.unboundRules);
        this.ruleBindings.add(binder);
        return binder;
    }

    @Override
    public <T> T realize(String path, Class<T> type) {
        return this.realize(path, ModelType.of(type));
    }

    @Override
    public <T> T realize(String path, ModelType<T> type) {
        return this.realize(ModelPath.path(path), type);
    }

    @Override
    public <T> T realize(ModelPath path, ModelType<T> type) {
        return this.toType(type, this.require(path), "get(ModelPath, ModelType)");
    }

    public ModelNode atState(ModelPath path, ModelNode.State state) {
        return this.atStateOrMaybeLater(path, state, false);
    }

    @Override
    public ModelNode atStateOrLater(ModelPath path, ModelNode.State state) {
        return this.atStateOrMaybeLater(path, state, true);
    }

    @Override
    public <T> T atStateOrLater(ModelPath path, ModelType<T> type, ModelNode.State state) {
        return this.toType(type, this.atStateOrMaybeLater(path, state, true), "atStateOrLater(ModelPath, ModelType, ModelNode.State)");
    }

    private ModelNodeInternal atStateOrMaybeLater(ModelPath path, ModelNode.State state, boolean laterOk) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            throw new IllegalStateException("No model node at '" + path + "'");
        }
        this.transition(node, state, laterOk);
        return node;
    }

    @Override
    public <T> T find(String path, Class<T> type) {
        return this.find(path, ModelType.of(type));
    }

    @Override
    public <T> T find(String path, ModelType<T> type) {
        return this.find(ModelPath.path(path), type);
    }

    @Override
    public <T> T find(ModelPath path, ModelType<T> type) {
        return this.toType(type, this.get(path), "find(ModelPath, ModelType)");
    }

    private <T> T toType(ModelType<T> type, ModelNodeInternal node, String msg) {
        if (node == null) {
            return null;
        }
        return node.asImmutable(type, new SimpleModelRuleDescriptor(msg)).getInstance();
    }

    @Override
    public ModelNode realizeNode(ModelPath path) {
        return this.require(path);
    }

    private void registerListener(ModelListener listener) {
        this.modelGraph.addListener(listener);
    }

    @Override
    public void remove(ModelPath path) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return;
        }
        ArrayList nodesToRemove = Lists.newArrayList();
        this.ensureCanRemove(node, nodesToRemove);
        Collections.reverse(nodesToRemove);
        for (ModelNodeInternal nodeToRemove : nodesToRemove) {
            this.modelGraph.remove(nodeToRemove);
            this.ruleBindings.remove(nodeToRemove);
            this.unboundRules.removeAll(nodeToRemove.getRegistrationActionBinders());
        }
    }

    private void ensureCanRemove(ModelNodeInternal node, List<ModelNodeInternal> nodesToRemove) {
        if (!(node instanceof ModelReferenceNode)) {
            for (ModelNodeInternal modelNodeInternal : node.getLinks()) {
                this.ensureCanRemove(modelNodeInternal, nodesToRemove);
            }
        }
        if (!Iterables.isEmpty(node.getDependents())) {
            throw new IllegalStateException(String.format("Tried to remove model '%s' but it is depended on by: '%s'", node.getPath(), Joiner.on((String)", ").join(node.getDependents())));
        }
        nodesToRemove.add(node);
    }

    @Override
    public void bindAllReferences() throws UnboundModelRulesException {
        GoalGraph graph = new GoalGraph();
        for (ModelNodeInternal node : this.modelGraph.getFlattened().values()) {
            if (node.isAtLeast(ModelNode.State.Discovered)) continue;
            this.transitionTo(graph, new Discover(node.getPath()));
        }
        if (this.unboundRules.isEmpty()) {
            return;
        }
        boolean newInputsBound = true;
        while (!this.unboundRules.isEmpty() && newInputsBound) {
            RuleBinder[] unboundBinders;
            newInputsBound = false;
            for (RuleBinder binder : unboundBinders = this.unboundRules.toArray(new RuleBinder[0])) {
                this.transitionTo(graph, new TryBindInputs(binder));
                newInputsBound = newInputsBound || binder.isBound();
            }
        }
        if (!this.unboundRules.isEmpty()) {
            TreeSet<RuleBinder> sortedBinders = new TreeSet<RuleBinder>(new Comparator<RuleBinder>(){

                @Override
                public int compare(RuleBinder o1, RuleBinder o2) {
                    return String.valueOf(o1.getDescriptor()).compareTo(String.valueOf(o2.getDescriptor()));
                }
            });
            sortedBinders.addAll(this.unboundRules);
            throw this.unbound(sortedBinders);
        }
    }

    private UnboundModelRulesException unbound(Iterable<? extends RuleBinder> binders) {
        ModelPathSuggestionProvider suggestionsProvider = new ModelPathSuggestionProvider(this.modelGraph.getFlattened().keySet());
        List<? extends UnboundRule> unboundRules = new UnboundRulesProcessor(binders, suggestionsProvider).process();
        return new UnboundModelRulesException(unboundRules);
    }

    private ModelNodeInternal require(ModelPath path) {
        ModelNodeInternal node = this.get(path);
        if (node == null) {
            throw new IllegalStateException("No model node at '" + path + "'");
        }
        return node;
    }

    @Override
    public ModelNode.State state(ModelPath path) {
        ModelNodeInternal modelNode = this.modelGraph.find(path);
        return modelNode == null ? null : modelNode.getState();
    }

    private ModelNodeInternal get(ModelPath path) {
        GoalGraph graph = new GoalGraph();
        this.transitionTo(graph, graph.nodeAtState(new NodeAtState(path, ModelNode.State.Registered)));
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return null;
        }
        this.transitionTo(graph, graph.nodeAtState(new NodeAtState(path, ModelNode.State.GraphClosed)));
        return node;
    }

    private void transitionTo(GoalGraph goalGraph, ModelGoal targetGoal) {
        ArrayDeque<ModelGoal> queue = new ArrayDeque<ModelGoal>();
        queue.add(targetGoal);
        ArrayList<ModelGoal> newDependencies = new ArrayList<ModelGoal>();
        while (!queue.isEmpty()) {
            ModelGoal goal = (ModelGoal)queue.getFirst();
            if (goal.state == ModelGoal.State.Achieved) {
                queue.removeFirst();
                continue;
            }
            if (goal.state == ModelGoal.State.NotSeen && goal.isAchieved()) {
                goal.state = ModelGoal.State.Achieved;
                queue.removeFirst();
                continue;
            }
            if (goal.state == ModelGoal.State.VisitingDependencies) {
                goal.apply();
                goal.state = ModelGoal.State.Achieved;
                queue.removeFirst();
                continue;
            }
            newDependencies.clear();
            goal.attachNode();
            boolean done = goal.calculateDependencies(goalGraph, newDependencies);
            goal.state = done || newDependencies.isEmpty() ? ModelGoal.State.VisitingDependencies : ModelGoal.State.DiscoveringDependencies;
            for (int i = newDependencies.size() - 1; i >= 0; --i) {
                ModelGoal dependency = (ModelGoal)newDependencies.get(i);
                if (dependency.state == ModelGoal.State.Achieved) continue;
                if (dependency.state == ModelGoal.State.NotSeen) {
                    queue.addFirst(dependency);
                    continue;
                }
                throw this.ruleCycle(dependency, Lists.newArrayList(queue));
            }
        }
    }

    private ConfigurationCycleException ruleCycle(ModelGoal brokenGoal, List<ModelGoal> queue) {
        ArrayList<String> path = new ArrayList<String>();
        int pos = queue.indexOf(brokenGoal);
        ListIterator<ModelGoal> iterator = queue.listIterator(pos + 1);
        while (iterator.hasPrevious()) {
            ModelGoal goal = iterator.previous();
            goal.attachToCycle(path);
        }
        brokenGoal.attachToCycle(path);
        Formatter out = new Formatter();
        out.format("A cycle has been detected in model rule dependencies. References forming the cycle:", new Object[0]);
        String last = null;
        StringBuilder indent = new StringBuilder("");
        for (int i = 0; i < path.size(); ++i) {
            String node = (String)path.get(i);
            if (node.equals(last)) continue;
            last = node;
            if (i == 0) {
                out.format("%n%s%s", indent, node);
                continue;
            }
            out.format("%n%s\\- %s", indent, node);
            indent.append("   ");
        }
        return new ConfigurationCycleException(out.toString());
    }

    @Override
    public void transition(ModelNodeInternal node, ModelNode.State desired, boolean laterOk) {
        ModelPath path = node.getPath();
        ModelNode.State state = node.getState();
        LOGGER.debug("Project {} - Transitioning model element '{}' from state {} to {}", new Object[]{this.projectPath, path, state.name(), desired.name()});
        if (desired.ordinal() < state.ordinal()) {
            if (laterOk) {
                return;
            }
            throw new IllegalStateException("Cannot lifecycle model node '" + path + "' to state " + desired.name() + " as it is already at " + state.name());
        }
        if (state == desired) {
            return;
        }
        GoalGraph goalGraph = new GoalGraph();
        this.transitionTo(goalGraph, goalGraph.nodeAtState(new NodeAtState(node.getPath(), desired)));
    }

    private void fireAction(RuleBinder boundMutator) {
        final List<ModelView<?>> inputs = this.toViews(boundMutator.getInputBindings(), boundMutator.getAction().getDescriptor());
        ModelBinding subjectBinding = boundMutator.getSubjectBinding();
        final ModelNodeInternal node = subjectBinding.getNode();
        final ModelAction mutator = boundMutator.getAction();
        ModelRuleDescriptor descriptor = mutator.getDescriptor();
        LOGGER.debug("Project {} - Mutating {} using {}", new Object[]{this.projectPath, node.getPath(), descriptor});
        try {
            RuleContext.run(descriptor, new Runnable(){

                @Override
                public void run() {
                    mutator.execute(node, inputs);
                }
            });
        }
        catch (Throwable e) {
            throw new ModelRuleExecutionException(descriptor, e);
        }
    }

    private List<ModelView<?>> toViews(List<ModelBinding> bindings, ModelRuleDescriptor descriptor) {
        ModelView[] array = new ModelView[bindings.size()];
        int i = 0;
        for (ModelBinding binding : bindings) {
            ModelNodeInternal element = binding.getNode();
            ModelView<?> view = element.asImmutable(binding.getPredicate().getType(), descriptor);
            array[i++] = view;
        }
        List<ModelView<?>> views = Arrays.asList(array);
        return views;
    }

    @Override
    public MutableModelNode getRoot() {
        return this.modelGraph.getRoot();
    }

    @Nullable
    public MutableModelNode node(ModelPath path) {
        return this.modelGraph.find(path);
    }

    private BindingPredicate mapSubject(ModelReference<?> subjectReference, ModelActionRole role) {
        if (!role.isSubjectViewAvailable() && !subjectReference.isUntyped()) {
            throw new IllegalStateException(String.format("Cannot bind subject '%s' to role '%s' because it is targeting a type and subject types are not yet available in that role", new Object[]{subjectReference, role}));
        }
        return new BindingPredicate(subjectReference.atState(role.getTargetState()));
    }

    private List<BindingPredicate> mapInputs(List<? extends ModelReference<?>> inputs) {
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BindingPredicate> result = new ArrayList<BindingPredicate>(inputs.size());
        for (ModelReference<?> input : inputs) {
            if (input.getPath() == null && input.getScope() == null) {
                result.add(new BindingPredicate(input.inScope(ModelPath.ROOT)));
                continue;
            }
            result.add(new BindingPredicate(input));
        }
        return result;
    }

    private static abstract class DelegatingListener
    extends ModelListener {
        private final ModelSpec spec;

        public DelegatingListener(ModelSpec spec) {
            this.spec = spec;
        }

        @Override
        @Nullable
        public ModelPath getPath() {
            return this.spec.getPath();
        }

        @Override
        @Nullable
        public ModelPath getParent() {
            return this.spec.getParent();
        }

        @Override
        @Nullable
        public ModelPath getAncestor() {
            return this.spec.getAncestor();
        }
    }

    private class NotifyDiscovered
    extends ModelNodeGoal {
        protected NotifyDiscovered(ModelPath target) {
            super(target);
        }

        @Override
        void apply() {
            DefaultModelRegistry.this.ruleBindings.nodeDiscovered(this.node);
            DefaultModelRegistry.this.modelGraph.nodeDiscovered(this.node);
        }

        @Override
        public String toString() {
            return "notify discovered for " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }
    }

    private class RunModelAction
    extends ModelNodeGoal {
        private final RuleBinder binder;
        private boolean bindInputs;

        public RunModelAction(ModelPath path, RuleBinder binder) {
            super(path);
            this.binder = binder;
        }

        @Override
        public String toString() {
            return "run action for " + this.binder.getSubjectBinding().getPredicate() + ", rule: " + this.binder.getDescriptor() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.bindInputs) {
                dependencies.add(new TryBindInputs(this.binder));
                this.bindInputs = true;
                return false;
            }
            if (!this.binder.isBound()) {
                throw DefaultModelRegistry.this.unbound(Collections.singleton(this.binder));
            }
            for (ModelBinding binding : this.binder.getInputBindings()) {
                dependencies.add(graph.nodeAtState(new NodeAtState(binding.getNode().getPath(), binding.getPredicate().getState())));
            }
            return true;
        }

        @Override
        void attachToCycle(List<String> displayValue) {
            displayValue.add(this.binder.getDescriptor().toString());
        }

        @Override
        void apply() {
            LOGGER.debug("Project {} - Running model element '{}' rule action {}", new Object[]{DefaultModelRegistry.this.projectPath, this.getPath(), this.binder.getDescriptor()});
            DefaultModelRegistry.this.fireAction(this.binder);
            this.node.notifyFired(this.binder);
        }
    }

    private class TryBindInputs
    extends ModelGoal {
        private final RuleBinder binder;

        public TryBindInputs(RuleBinder binder) {
            this.binder = binder;
        }

        @Override
        public String toString() {
            return "bind inputs for " + this.binder.getDescriptor() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            this.maybeBind(this.binder.getSubjectBinding(), dependencies);
            for (ModelBinding binding : this.binder.getInputBindings()) {
                this.maybeBind(binding, dependencies);
            }
            return true;
        }

        private void maybeBind(ModelBinding binding, Collection<ModelGoal> dependencies) {
            if (!binding.isBound()) {
                BindingPredicate predicate = binding.getPredicate();
                if (predicate.getPath() != null) {
                    dependencies.add(new TryResolveAndDiscoverPath(predicate.getPath()));
                } else {
                    dependencies.add(new TryDefineScopeForType(predicate.getScope(), predicate.getType()));
                }
            }
        }
    }

    private class TryDefineScopeForType
    extends ModelGoal {
        private final ModelPath scope;
        private final ModelType<?> typeToBind;
        private boolean attemptedPath;
        private boolean attemptedSelfDiscoveringChildren;
        private boolean attemptedCloseScope;

        public TryDefineScopeForType(ModelPath scope, ModelType<?> typeToBind) {
            this.scope = scope;
            this.typeToBind = typeToBind;
        }

        @Override
        public boolean isAchieved() {
            ModelNodeInternal node = DefaultModelRegistry.this.modelGraph.find(this.scope);
            if (node == null) {
                return false;
            }
            for (ModelNodeInternal modelNodeInternal : node.getLinks()) {
                if (!modelNodeInternal.isAtLeast(ModelNode.State.Discovered) || !modelNodeInternal.getPromise().canBeViewedAs(this.typeToBind)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.attemptedPath) {
                dependencies.add(new TryResolvePath(this.scope));
                this.attemptedPath = true;
                return false;
            }
            ModelNodeInternal scopeNode = DefaultModelRegistry.this.modelGraph.find(this.scope);
            if (scopeNode == null) {
                return true;
            }
            if (!this.attemptedSelfDiscoveringChildren) {
                dependencies.add(new TryDiscoverSelfDiscoveringInScope(scopeNode));
                this.attemptedSelfDiscoveringChildren = true;
                return false;
            }
            if (this.isAchieved()) {
                return true;
            }
            if (!this.attemptedCloseScope) {
                dependencies.add(graph.nodeAtState(new NodeAtState(this.scope, ModelNode.State.SelfClosed)));
                this.attemptedCloseScope = true;
                return false;
            }
            dependencies.add(new TransitionChildrenOrReference(this.scope, ModelNode.State.Discovered));
            return true;
        }

        @Override
        public String toString() {
            return "try define scope " + this.scope + " to bind type " + this.typeToBind + ", state: " + (Object)((Object)this.state);
        }
    }

    private class TryDiscoverSelfDiscoveringInScope
    extends ModelGoal {
        private final ModelNodeInternal scopeNode;

        public TryDiscoverSelfDiscoveringInScope(ModelNodeInternal scopeNode) {
            this.scopeNode = scopeNode;
        }

        @Override
        public boolean isAchieved() {
            for (ModelNodeInternal modelNodeInternal : this.scopeNode.getLinks()) {
                if (modelNodeInternal.isAtLeast(ModelNode.State.Discovered) || this.hasInputs(new NodeAtState(modelNodeInternal.getPath(), ModelNode.State.Discovered))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            for (ModelNodeInternal modelNodeInternal : this.scopeNode.getLinks()) {
                NodeAtState target = new NodeAtState(modelNodeInternal.getPath(), ModelNode.State.Discovered);
                if (modelNodeInternal.isAtLeast(ModelNode.State.Discovered) || this.hasInputs(target)) continue;
                dependencies.add(graph.nodeAtState(target));
            }
            return false;
        }

        @Override
        public String toString() {
            return "try discover self-discovering children of scope " + this.scopeNode.getPath() + ", state: " + (Object)((Object)this.state);
        }

        private boolean hasInputs(NodeAtState target) {
            for (RuleBinder ruleBinder : DefaultModelRegistry.this.ruleBindings.getRulesWithSubject(target)) {
                if (ruleBinder.getInputBindings().isEmpty()) continue;
                return true;
            }
            return false;
        }
    }

    private class TryResolveReference
    extends ModelGoal {
        private final ModelReferenceNode parent;
        private final ModelPath path;

        public TryResolveReference(ModelReferenceNode parent, ModelPath path) {
            this.parent = parent;
            this.path = path;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            dependencies.add(new TryResolveAndDiscoverPath(this.parent.getTarget().getPath().child(this.path.getName())));
            return true;
        }

        @Override
        void apply() {
            ModelNodeInternal parentTarget = this.parent.getTarget();
            ModelNodeInternal childTarget = parentTarget.getLink(this.path.getName());
            if (childTarget == null) {
                throw new NullPointerException("child is null");
            }
            ModelRegistration registration = ModelRegistrations.of(this.path).descriptor(this.parent.getDescriptor()).withProjection(childTarget.getProjection()).build();
            ModelReferenceNode childNode = new ModelReferenceNode(DefaultModelRegistry.this, registration, this.parent);
            childNode.setTarget(childTarget);
            DefaultModelRegistry.this.registerNode(childNode, (Multimap<ModelActionRole, ? extends ModelAction>)ImmutableMultimap.of());
        }

        @Override
        public String toString() {
            return "try resolve reference " + this.path + ", state: " + (Object)((Object)this.state);
        }
    }

    private class TryResolveAndDiscoverPath
    extends TryResolvePath {
        private boolean attemptedPath;

        public TryResolveAndDiscoverPath(ModelPath path) {
            super(path);
        }

        @Override
        protected boolean doIsAchieved() {
            return this.node.isAtLeast(ModelNode.State.Discovered);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (DefaultModelRegistry.this.modelGraph.find(this.getPath()) == null) {
                if (!this.attemptedPath) {
                    this.attemptedPath = super.calculateDependencies(graph, dependencies);
                    return false;
                }
                return true;
            }
            dependencies.add(graph.nodeAtState(new NodeAtState(this.getPath(), ModelNode.State.Discovered)));
            return true;
        }

        @Override
        public String toString() {
            return "try discover and resolve path " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }
    }

    private class TryResolvePath
    extends ModelNodeGoal {
        private boolean attemptedParent;

        public TryResolvePath(ModelPath path) {
            super(path);
        }

        @Override
        protected boolean doIsAchieved() {
            return true;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.attemptedParent) {
                dependencies.add(new TryResolvePath(this.getPath().getParent()));
                this.attemptedParent = true;
                return false;
            }
            ModelNodeInternal parent = DefaultModelRegistry.this.modelGraph.find(this.getPath().getParent());
            if (parent == null) {
                return true;
            }
            if (parent instanceof ModelReferenceNode) {
                ModelReferenceNode parentReference = (ModelReferenceNode)parent;
                if (parentReference.getTarget() != null) {
                    dependencies.add(new TryResolveReference(parentReference, this.getPath()));
                }
            } else {
                dependencies.add(graph.nodeAtState(new NodeAtState(this.getPath().getParent(), ModelNode.State.SelfClosed)));
            }
            return true;
        }

        @Override
        public String toString() {
            return "try resolve path " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }
    }

    private class CloseGraph
    extends TransitionNodeToState {
        public CloseGraph(NodeAtState target) {
            super(target);
        }

        @Override
        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            dependencies.add(new TransitionChildrenOrReference(this.getPath(), ModelNode.State.GraphClosed));
            return true;
        }
    }

    private class ApplyActions
    extends TransitionNodeToState {
        private final Set<RuleBinder> seenRules;

        public ApplyActions(NodeAtState target) {
            super(target);
            this.seenRules = new HashSet<RuleBinder>();
        }

        @Override
        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            boolean noActionsAdded = true;
            for (RuleBinder binder : DefaultModelRegistry.this.ruleBindings.getRulesWithSubject(this.target)) {
                if (!this.seenRules.add(binder)) continue;
                noActionsAdded = false;
                dependencies.add(new RunModelAction(this.getPath(), binder));
            }
            return noActionsAdded;
        }
    }

    private class TransitionChildrenOrReference
    extends ModelNodeGoal {
        private final ModelNode.State targetState;

        protected TransitionChildrenOrReference(ModelPath target, ModelNode.State targetState) {
            super(target);
            this.targetState = targetState;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (this.node instanceof ModelReferenceNode) {
                ModelReferenceNode referenceNode = (ModelReferenceNode)this.node;
                ModelNodeInternal modelNodeInternal = referenceNode.getTarget();
                if (modelNodeInternal == null || modelNodeInternal.getPath().isDescendant(this.node.getPath())) {
                    return true;
                }
                if (!modelNodeInternal.isAtLeast(this.targetState)) {
                    dependencies.add(graph.nodeAtState(new NodeAtState(modelNodeInternal.getPath(), this.targetState)));
                }
            } else {
                for (ModelNodeInternal modelNodeInternal : this.node.getLinks()) {
                    if (modelNodeInternal.isAtLeast(this.targetState)) continue;
                    dependencies.add(graph.nodeAtState(new NodeAtState(modelNodeInternal.getPath(), this.targetState)));
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return "transition children of " + this.getPath() + " to " + (Object)((Object)this.targetState) + ", state: " + (Object)((Object)this.state);
        }
    }

    private class TransitionDependents
    extends ModelGoal {
        private final NodeAtState input;

        public TransitionDependents(NodeAtState input) {
            this.input = input;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            for (RuleBinder rule : DefaultModelRegistry.this.ruleBindings.getRulesWithInput(this.input)) {
                ModelPath targetPath;
                ModelBinding subjectBinding = rule.getSubjectBinding();
                if (!subjectBinding.isBound() || (targetPath = subjectBinding.getNode().getPath()).equals(this.input.path)) continue;
                ModelNode.State targetState = subjectBinding.getPredicate().getState();
                dependencies.add(graph.nodeAtState(new NodeAtState(targetPath, targetState)));
            }
            return true;
        }

        @Override
        public String toString() {
            return "transition dependents " + this.input.path + ", target: " + (Object)((Object)this.input.state) + ", state: " + (Object)((Object)this.state);
        }
    }

    private class Discover
    extends ModelNodeGoal {
        public Discover(ModelPath path) {
            super(path);
        }

        @Override
        public boolean doIsAchieved() {
            return this.node.isAtLeast(ModelNode.State.Discovered);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            dependencies.add(new ApplyActions(new NodeAtState(this.getPath(), ModelNode.State.Discovered)));
            dependencies.add(new NotifyDiscovered(this.getPath()));
            return true;
        }

        @Override
        public String toString() {
            return "discover " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }
    }

    private abstract class TransitionNodeToState
    extends ModelNodeGoal {
        final NodeAtState target;
        private boolean seenPredecessor;

        public TransitionNodeToState(NodeAtState target) {
            super(target.path);
            this.target = target;
        }

        @Override
        public String toString() {
            return "transition " + this.getPath() + ", target: " + (Object)((Object)this.target.state) + ", state: " + (Object)((Object)this.state);
        }

        public ModelNode.State getTargetState() {
            return this.target.state;
        }

        @Override
        public boolean doIsAchieved() {
            return this.node.getState().compareTo(this.getTargetState()) >= 0;
        }

        @Override
        public final boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.seenPredecessor) {
                NodeAtState predecessor = new NodeAtState(this.getPath(), this.getTargetState().previous());
                dependencies.add(graph.nodeAtState(predecessor));
                dependencies.add(new TransitionDependents(predecessor));
                this.seenPredecessor = true;
                return false;
            }
            if (this.node == null) {
                throw new IllegalStateException(String.format("Cannot transition model element '%s' to state %s as it does not exist.", this.getPath(), this.getTargetState().name()));
            }
            return this.doCalculateDependencies(graph, dependencies);
        }

        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            return true;
        }

        @Override
        public final void apply() {
            if (!this.node.getState().equals((Object)this.getTargetState().previous())) {
                throw new IllegalStateException(String.format("Cannot transition model element '%s' to state %s as it is already at state %s.", new Object[]{this.node.getPath(), this.getTargetState(), this.node.getState()}));
            }
            LOGGER.debug("Project {} - Transitioning model element '{}' to state {}.", new Object[]{DefaultModelRegistry.this.projectPath, this.node.getPath(), this.getTargetState().name()});
            this.node.setState(this.getTargetState());
        }

        @Override
        void attachToCycle(List<String> displayValue) {
            displayValue.add(this.getPath().toString());
        }
    }

    private class MakeKnown
    extends ModelNodeGoal {
        public MakeKnown(ModelPath path) {
            super(path);
        }

        @Override
        public String toString() {
            return "make known " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean doIsAchieved() {
            return true;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            ModelPath parent = this.getPath().getParent();
            if (parent != null) {
                dependencies.add(graph.nodeAtState(new NodeAtState(parent, ModelNode.State.SelfClosed)));
            }
            return true;
        }
    }

    private abstract class ModelNodeGoal
    extends ModelGoal {
        public final ModelPath target;
        public ModelNodeInternal node;

        protected ModelNodeGoal(ModelPath target) {
            this.target = target;
        }

        public ModelPath getPath() {
            return this.target;
        }

        @Override
        public final boolean isAchieved() {
            this.node = DefaultModelRegistry.this.modelGraph.find(this.target);
            return this.node != null && this.doIsAchieved();
        }

        protected boolean doIsAchieved() {
            return false;
        }

        @Override
        public void attachNode() {
            if (this.node != null) {
                return;
            }
            this.node = DefaultModelRegistry.this.modelGraph.find(this.getPath());
        }
    }

    private static abstract class ModelGoal {
        public State state = State.NotSeen;

        private ModelGoal() {
        }

        public boolean isAchieved() {
            return false;
        }

        public void attachNode() {
        }

        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            return true;
        }

        void apply() {
        }

        void attachToCycle(List<String> displayValue) {
        }

        public abstract String toString();

        static enum State {
            NotSeen,
            DiscoveringDependencies,
            VisitingDependencies,
            Achieved;

        }
    }

    private class GoalGraph {
        private final Map<NodeAtState, ModelGoal> nodeStates = new HashMap<NodeAtState, ModelGoal>();

        private GoalGraph() {
        }

        public ModelGoal nodeAtState(NodeAtState goal) {
            ModelGoal node = this.nodeStates.get(goal);
            if (node == null) {
                switch (goal.state) {
                    case Registered: {
                        node = new MakeKnown(goal.path);
                        break;
                    }
                    case Discovered: {
                        node = new Discover(goal.path);
                        break;
                    }
                    case GraphClosed: {
                        node = new CloseGraph(goal);
                        break;
                    }
                    default: {
                        node = new ApplyActions(goal);
                    }
                }
                this.nodeStates.put(goal, node);
            }
            return node;
        }
    }
}

