/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.toolchain;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.fingerprint.ClasspathFingerprinter;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.javascript.GoogleClosureCompiler;
import org.gradle.play.internal.routes.RoutesCompilerFactory;
import org.gradle.play.internal.toolchain.DefaultPlayToolProvider;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.internal.twirl.TwirlCompilerFactory;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.util.CollectionUtils;
import org.gradle.util.TreeVisitor;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class DefaultPlayToolChain
implements PlayToolChainInternal {
    private final PathToFileResolver fileResolver;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final WorkerProcessFactory workerProcessBuilderFactory;
    private final WorkerDirectoryProvider workerDirectoryProvider;
    private final ClasspathFingerprinter fingerprinter;

    public DefaultPlayToolChain(PathToFileResolver fileResolver, WorkerDaemonFactory workerDaemonFactory, ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler, WorkerProcessFactory workerProcessBuilderFactory, WorkerDirectoryProvider workerDirectoryProvider, ClasspathFingerprinter fingerprinter) {
        this.fileResolver = fileResolver;
        this.workerDaemonFactory = workerDaemonFactory;
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.workerProcessBuilderFactory = workerProcessBuilderFactory;
        this.workerDirectoryProvider = workerDirectoryProvider;
        this.fingerprinter = fingerprinter;
    }

    @Override
    public String getName() {
        return "PlayToolchain";
    }

    @Override
    public String getDisplayName() {
        return "Default Play Toolchain";
    }

    @Override
    public PlayToolProvider select(PlayPlatform targetPlatform) {
        try {
            Set<File> twirlClasspath = this.resolveToolClasspath(TwirlCompilerFactory.createAdapter(targetPlatform).getDependencyNotation().toArray()).resolve();
            Set<File> routesClasspath = this.resolveToolClasspath(RoutesCompilerFactory.createAdapter(targetPlatform).getDependencyNotation()).resolve();
            Set<File> javascriptClasspath = this.resolveToolClasspath(GoogleClosureCompiler.getDependencyNotation()).resolve();
            return new DefaultPlayToolProvider(this.fileResolver, this.workerDirectoryProvider.getIdleWorkingDirectory(), this.workerDaemonFactory, this.workerProcessBuilderFactory, targetPlatform, twirlClasspath, routesClasspath, javascriptClasspath, this.fingerprinter);
        }
        catch (ResolveException e) {
            return new UnavailablePlayToolProvider(e);
        }
    }

    private Configuration resolveToolClasspath(Object ... dependencyNotations) {
        List<Dependency> dependencies = CollectionUtils.collect(dependencyNotations, new Transformer<Dependency, Object>(){

            @Override
            public Dependency transform(Object dependencyNotation) {
                return DefaultPlayToolChain.this.dependencyHandler.create(dependencyNotation);
            }
        });
        Dependency[] dependenciesArray = dependencies.toArray(new Dependency[0]);
        return this.configurationContainer.detachedConfiguration(dependenciesArray);
    }

    private static class UnavailablePlayToolProvider
    implements PlayToolProvider {
        private final Exception exception;

        public UnavailablePlayToolProvider(Exception exception) {
            this.exception = exception;
        }

        @Override
        public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
            throw this.failure();
        }

        @Override
        public <T> T get(Class<T> toolType) {
            throw this.failure();
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        private RuntimeException failure() {
            TreeFormatter formatter = new TreeFormatter();
            this.explain(formatter);
            return new GradleException(formatter.toString());
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node("Cannot provide Play tool provider");
            visitor.startChildren();
            visitor.node(this.exception.getCause().getMessage());
            visitor.endChildren();
        }
    }
}

