/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.impldep.org.apache.commons.lang.WordUtils;
import org.gradle.language.scala.tasks.PlatformScalaCompile;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.plugins.PlayPluginConfigurations;

@Incubating
public class PlayTestPlugin
extends RuleSource {
    @Mutate
    void createTestTasks(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<PlayApplicationBinarySpecInternal> playBinaries, PlayPluginConfigurations configurations, FileResolver fileResolver, final ProjectIdentifier projectIdentifier, final @Path(value="buildDir") File buildDir) {
        for (final PlayApplicationBinarySpecInternal binary : playBinaries) {
            PlayToolProvider playToolProvider = binary.getToolChain().select(binary.getTargetPlatform());
            final FileCollection testCompileClasspath = this.getTestCompileClasspath(binary, playToolProvider, configurations);
            final String testCompileTaskName = binary.getTasks().taskName("compile", "tests");
            File testSourceDir = fileResolver.resolve("test");
            final FileTree testSources = ImmutableFileCollection.of(testSourceDir).getAsFileTree().matching(new PatternSet().include("**/*.scala", "**/*.java"));
            final File testClassesDir = new File(buildDir, binary.getProjectScopedName() + "/testClasses");
            tasks.create(testCompileTaskName, PlatformScalaCompile.class, new Action<PlatformScalaCompile>(){

                @Override
                public void execute(PlatformScalaCompile scalaCompile) {
                    scalaCompile.setDescription("Compiles the scala and java test sources for the " + binary.getDisplayName() + ".");
                    scalaCompile.setClasspath(testCompileClasspath);
                    scalaCompile.dependsOn(binary.getBuildTask());
                    scalaCompile.setPlatform(binary.getTargetPlatform().getScalaPlatform());
                    scalaCompile.setDestinationDir(testClassesDir);
                    scalaCompile.setSource(testSources);
                    String targetCompatibility = binary.getTargetPlatform().getJavaPlatform().getTargetCompatibility().getMajorVersion();
                    scalaCompile.setSourceCompatibility(targetCompatibility);
                    scalaCompile.setTargetCompatibility(targetCompatibility);
                    IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                    incrementalOptions.getAnalysisFile().set(new File(buildDir, "tmp/scala/compilerAnalysis/" + testCompileTaskName + ".analysis"));
                }
            });
            final String testTaskName = binary.getTasks().taskName("test");
            final File binaryBuildDir = new File(buildDir, binary.getProjectScopedName());
            tasks.create(testTaskName, Test.class, new Action<Test>(){

                @Override
                public void execute(Test test) {
                    test.setDescription("Runs " + WordUtils.uncapitalize((String)(binary.getDisplayName() + ".")));
                    test.setClasspath(PlayTestPlugin.this.getRuntimeClasspath(testClassesDir, testCompileClasspath));
                    test.setTestClassesDirs(ImmutableFileCollection.of(testClassesDir));
                    test.setBinResultsDir(new File(binaryBuildDir, "results/" + testTaskName + "/bin"));
                    test.getReports().getJunitXml().setDestination(new File(binaryBuildDir, "reports/test/xml"));
                    test.getReports().getHtml().setDestination(new File(binaryBuildDir, "reports/test"));
                    test.dependsOn(testCompileTaskName);
                    test.setWorkingDir(projectIdentifier.getProjectDir());
                }
            });
            binary.getTasks().add(tasks.get(testTaskName));
        }
    }

    private FileCollection getTestCompileClasspath(PlayApplicationBinarySpec binary, PlayToolProvider playToolProvider, PlayPluginConfigurations configurations) {
        return ImmutableFileCollection.of(binary.getJarFile()).plus(configurations.getPlayTest().getAllArtifacts());
    }

    private FileCollection getRuntimeClasspath(File testClassesDir, FileCollection testCompileClasspath) {
        return ImmutableFileCollection.of(testClassesDir).plus(testCompileClasspath);
    }

    @Mutate
    void attachTestSuitesToCheckTask(ModelMap<Task> tasks, final @Path(value="binaries") ModelMap<PlayApplicationBinarySpec> playBinaries) {
        tasks.named("check", new Action<Task>(){

            @Override
            public void execute(Task checkTask) {
                for (PlayApplicationBinarySpec binary : playBinaries) {
                    checkTask.dependsOn(binary.getTasks().withType(Test.class));
                }
            }
        });
    }
}

