/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.setup.module.AndroidManifestSetupStep;
import com.android.tools.idea.apk.setup.module.AndroidSdkSetupStep;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.android.tools.idea.apk.setup.module.ModuleContentEntrySetupStep;
import com.android.tools.idea.apk.setup.module.NativeCodeSetupStep;
import com.android.tools.idea.project.AndroidRunConfigurations;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ApkModuleSetup {
    @NotNull
    private final ApkModuleSetupStep[] mySetupSteps;

    public ApkModuleSetup() {
        this(new ModuleContentEntrySetupStep(), new AndroidManifestSetupStep(), new AndroidSdkSetupStep(), new NativeCodeSetupStep());
    }

    @VisibleForTesting
    ApkModuleSetup(ApkModuleSetupStep ... setupSteps) {
        this.mySetupSteps = setupSteps;
    }

    void setUpApkModule(@NotNull Project project, @NotNull ApkSetupContext context) throws Throwable {
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(project);
        try {
            for (ApkModuleSetupStep step : this.mySetupSteps) {
                step.setUpModule((IdeModifiableModelsProvider)modelsProvider, context);
            }
            ApkModuleSetup.commitChanges(project, (IdeModifiableModelsProvider)modelsProvider);
        }
        catch (Exception e) {
            ApkModuleSetup.disposeChanges(project, (IdeModifiableModelsProvider)modelsProvider);
            throw e;
        }
        AndroidFacet androidFacet = context.getAndroidFacet();
        assert (androidFacet != null);
        AndroidRunConfigurations.getInstance().createRunConfiguration(androidFacet);
    }

    private static void commitChanges(@NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.commit();
            }
        });
    }

    private static void disposeChanges(@NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }
}

