/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.smali.psi.SmaliFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkProjectComponent
extends AbstractProjectComponent {
    @NotNull
    private final SetupIssueReporter myIssueReporter;
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final DaemonCodeAnalyzerEx myDaemonCodeAnalyzer;
    @NotNull
    private final SmaliCodeHighlightingBlocker.Factory myCodeHighlightingBlockerFactory;
    private MessageBusConnection myConnection;

    @NotNull
    public static ApkProjectComponent getInstance(@NotNull Project project) {
        ApkProjectComponent component = (ApkProjectComponent)((Object)project.getComponent(ApkProjectComponent.class));
        assert (component != null);
        return component;
    }

    public ApkProjectComponent(@NotNull Project project, @NotNull SetupIssueReporter issueReporter, @NotNull PsiManager psiManager, @NotNull DaemonCodeAnalyzerEx daemonCodeAnalyzer) {
        this(project, issueReporter, psiManager, daemonCodeAnalyzer, new SmaliCodeHighlightingBlocker.Factory());
    }

    @VisibleForTesting
    ApkProjectComponent(@NotNull Project project, @NotNull SetupIssueReporter issueReporter, @NotNull PsiManager psiManager, @NotNull DaemonCodeAnalyzerEx daemonCodeAnalyzer, @NotNull SmaliCodeHighlightingBlocker.Factory codeHighlightingBlockerFactory) {
        super(project);
        this.myIssueReporter = issueReporter;
        this.myPsiManager = psiManager;
        this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        this.myCodeHighlightingBlockerFactory = codeHighlightingBlockerFactory;
    }

    public void projectOpened() {
        ArrayList<ApkFacet> apkFacets = new ArrayList<ApkFacet>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApkFacet facet = ApkFacet.getInstance((Module)module);
            if (facet == null) continue;
            apkFacets.add(facet);
        }
        if (!apkFacets.isEmpty()) {
            MessageBus messageBus = this.myProject.getMessageBus();
            this.myConnection = messageBus.connect((Disposable)this.myProject);
            this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myCodeHighlightingBlockerFactory.create(this.myPsiManager, this.myDaemonCodeAnalyzer));
            for (ApkFacet facet : apkFacets) {
                this.myIssueReporter.reportSetupIssues(facet);
            }
        }
    }

    public void projectClosed() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    @VisibleForTesting
    @Nullable
    MessageBusConnection getConnection() {
        return this.myConnection;
    }

    @VisibleForTesting
    static class SmaliCodeHighlightingBlocker
    implements FileEditorManagerListener {
        @NotNull
        private final PsiManager myPsiManager;
        @NotNull
        private final DaemonCodeAnalyzerEx myDaemonCodeAnalyzer;

        SmaliCodeHighlightingBlocker(@NotNull PsiManager psiManager, @NotNull DaemonCodeAnalyzerEx daemonCodeAnalyzer) {
            this.myPsiManager = psiManager;
            this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            PsiFile psiFile = this.myPsiManager.findFile(file);
            if (psiFile instanceof SmaliFile) {
                this.myDaemonCodeAnalyzer.setHighlightingEnabled(psiFile, false);
            }
        }

        static class Factory {
            Factory() {
            }

            @NotNull
            SmaliCodeHighlightingBlocker create(@NotNull PsiManager psiManager, @NotNull DaemonCodeAnalyzerEx daemonCodeAnalyzer) {
                return new SmaliCodeHighlightingBlocker(psiManager, daemonCodeAnalyzer);
            }
        }
    }
}

