/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.Projects;
import com.android.tools.idea.apk.ApkFacet;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkSetupContext {
    @NotNull
    private final Module myModule;
    @NotNull
    private final VirtualFile myApkFile;
    @NotNull
    private final File myProjectRootFolderPath;
    @Nullable
    private ContentEntry myContentEntry;
    @Nullable
    private AndroidFacet myAndroidFacet;
    @Nullable
    private ApkFacet myApkFacet;
    @Nullable
    private Sdk myAndroidSdk;

    public ApkSetupContext(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull VirtualFile apkFile) {
        this.myModule = module;
        this.myAndroidFacet = AndroidFacet.getInstance((Module)module, (IdeModifiableModelsProvider)modelsProvider);
        this.myApkFacet = ApkFacet.getInstance((Module)module, (IdeModifiableModelsProvider)modelsProvider);
        this.myApkFile = apkFile;
        this.myProjectRootFolderPath = Projects.getBaseDirPath((Project)module.getProject());
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public VirtualFile getApkFile() {
        return this.myApkFile;
    }

    @NotNull
    public File getProjectRootFolderPath() {
        return this.myProjectRootFolderPath;
    }

    @Nullable
    public ContentEntry getContentEntry() {
        return this.myContentEntry;
    }

    public void setContentEntry(@NotNull ContentEntry contentEntry) {
        this.myContentEntry = contentEntry;
    }

    @Nullable
    public AndroidFacet getAndroidFacet() {
        return this.myAndroidFacet;
    }

    public void setAndroidFacet(@NotNull AndroidFacet androidFacet) {
        this.myAndroidFacet = androidFacet;
    }

    @Nullable
    public ApkFacet getApkFacet() {
        return this.myApkFacet;
    }

    public void setApkFacet(@NotNull ApkFacet apkFacet) {
        this.myApkFacet = apkFacet;
    }

    public void setAndroidSdk(@Nullable Sdk androidSdk) {
        this.myAndroidSdk = androidSdk;
    }

    @Nullable
    public Sdk getAndroidSdk() {
        return this.myAndroidSdk;
    }
}

