/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class OpenLibraryInEditorAction
extends AnAction
implements NotificationListener,
HyperlinkListener {
    @NotNull
    private final NativeLibrary myLibrary;
    @NotNull
    private final FileEditorManager myFileEditorManager;

    public OpenLibraryInEditorAction(@NotNull String text, @NotNull NativeLibrary library, @NotNull FileEditorManager fileEditorManager) {
        super(text);
        this.myLibrary = library;
        this.myFileEditorManager = fileEditorManager;
    }

    public OpenLibraryInEditorAction(@NotNull NativeLibrary library, @NotNull FileEditorManager fileEditorManager) {
        this.myLibrary = library;
        this.myFileEditorManager = fileEditorManager;
    }

    public void actionPerformed(AnActionEvent e) {
        this.openLibraryInEditor();
    }

    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
        this.hyperlinkUpdate(event);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.openLibraryInEditor();
        }
    }

    public void openLibraryInEditor() {
        List files = this.myLibrary.getSharedObjectFiles();
        assert (!files.isEmpty());
        this.myFileEditorManager.openFile((VirtualFile)files.get(0), true);
    }

    @NotNull
    public NativeLibrary getLibrary() {
        return this.myLibrary;
    }
}

