/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.LibraryUpdates;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.DebugSymbolTableView;
import com.android.tools.idea.apk.editor.DebugSymbolsEditorForm;
import com.android.tools.idea.apk.editor.PathMappingEditorForm;
import com.android.tools.idea.apk.editor.PathMappingTreeTableView;
import com.android.tools.idea.apk.editor.SharedObjectFileChooserDescriptor;
import com.android.tools.idea.apk.symbols.DebugSymbolNotifications;
import com.android.tools.idea.apk.symbols.DebugSymbolsUpdater;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.idea.apk.symbols.SharedObjectFileFinder;
import com.android.tools.idea.apk.symbols.SourceFoldersUpdater;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.FileOrFolderChooser;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryEditorForm {
    private static final String NOTIFICATION_TITLE = "APK Debugging";
    @NotNull
    private final ApkFacet myApkFacet;
    @NotNull
    private final Project myProject;
    @NotNull
    private final NativeLibrary myLibrary;
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final SharedObjectFileFinder mySharedObjectFileFinder;
    @NotNull
    private final DebugSymbolsUpdater myDebugSymbolsUpdater;
    @NotNull
    private final SourceFoldersUpdater mySourceFoldersUpdater;
    @NotNull
    private final DebugSymbolNotifications myDebugSymbolNotifications;
    @NotNull
    private final FolderOrSharedObjectFileChooserFactory myFolderOrSharedObjectFileChooserFactory;
    private final PathMappingTreeTableView myPathMappingTableView;
    private final DebugSymbolTableView myDebugSymbolTableView;
    private boolean myContentsUpdated;
    private boolean myPathMappingsCleared;
    private final Splitter mySplitter;
    private final DebugSymbolsEditorForm myDebugSymbolsEditorForm;
    private final PathMappingEditorForm myPathMappingEditorForm;

    LibraryEditorForm(@NotNull ApkFacet apkFacet, @NotNull NativeLibrary library, @Nullable Disposable parent) {
        this(apkFacet, library, IdeSdks.getInstance(), new SharedObjectFileFinder(), new DebugSymbolsUpdater(), new SourceFoldersUpdater(), DebugSymbolNotifications.getInstance(), new FolderOrSharedObjectFileChooserFactory(), parent);
    }

    @VisibleForTesting
    LibraryEditorForm(@NotNull ApkFacet apkFacet, @NotNull NativeLibrary library, @NotNull IdeSdks ideSdks, @NotNull SharedObjectFileFinder sharedObjectFileFinder, @NotNull DebugSymbolsUpdater debugSymbolsUpdater, @NotNull SourceFoldersUpdater sourceFoldersUpdater, @NotNull DebugSymbolNotifications debugSymbolNotifications, @NotNull FolderOrSharedObjectFileChooserFactory folderOrSharedObjectFileChooserFactory, @Nullable Disposable parent) {
        this.myApkFacet = apkFacet;
        this.myLibrary = library;
        this.myIdeSdks = ideSdks;
        this.mySharedObjectFileFinder = sharedObjectFileFinder;
        this.myDebugSymbolsUpdater = debugSymbolsUpdater;
        this.mySourceFoldersUpdater = sourceFoldersUpdater;
        this.myDebugSymbolNotifications = debugSymbolNotifications;
        this.myFolderOrSharedObjectFileChooserFactory = folderOrSharedObjectFileChooserFactory;
        this.myProject = apkFacet.getModule().getProject();
        this.mySplitter = new OnePixelSplitter(true, "apk.debugging.library.editor.splitter.proportion", 0.5f);
        this.mySplitter.setName("libraryEditorForm");
        this.myDebugSymbolsEditorForm = new DebugSymbolsEditorForm();
        this.mySplitter.setFirstComponent((JComponent)this.myDebugSymbolsEditorForm.mainPanel);
        this.myPathMappingEditorForm = new PathMappingEditorForm();
        this.mySplitter.setSecondComponent((JComponent)this.myPathMappingEditorForm.mainPanel);
        if (parent != null) {
            LibraryUpdates.subscribe(this.myProject, libraries -> {
                if (libraries.contains(library)) {
                    this.updateContents();
                }
            }, parent);
        }
        this.setFormBackground();
        this.myPathMappingEditorForm.notificationLabel.setBorder(JBUI.Borders.empty((int)2));
        this.myPathMappingEditorForm.notificationLabel.setName("pathMappingsLabel");
        this.myDebugSymbolTableView = new DebugSymbolTableView(this.myLibrary);
        this.myDebugSymbolsEditorForm.viewPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myDebugSymbolTableView)), "Center");
        this.myDebugSymbolsEditorForm.addButton.addActionListener(e -> this.findAndAttachDebuggableSharedObjectFiles());
        this.myDebugSymbolsEditorForm.clearButton.addActionListener(e -> this.clearDebugSymbolsFilePaths());
        this.myPathMappingTableView = PathMappingTreeTableView.create(this.myLibrary, this.myProject);
        this.myPathMappingTableView.addPropertyChangeListener("pathMappings", evt -> {
            Map mappings = (Map)evt.getNewValue();
            if (mappings.equals(this.myLibrary.pathMappings)) {
                return;
            }
            this.myLibrary.replacePathMappingsWith(mappings);
            this.myPathMappingEditorForm.applyChangesLabel.setVisible(true);
        });
        this.myPathMappingTableView.setName("pathMappingTable");
        this.myPathMappingEditorForm.viewPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myPathMappingTableView)), "Center");
        this.updateContents();
        this.myPathMappingEditorForm.clearButton.addActionListener(e -> this.clearPathMappings());
        this.myPathMappingEditorForm.applyChangesLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                LibraryEditorForm.this.applyPathMappings();
            }
        });
    }

    private void findAndAttachDebuggableSharedObjectFiles() {
        Project project;
        FileOrFolderChooser fileOrFolderChooser = this.myFolderOrSharedObjectFileChooserFactory.create(this.myApkFacet);
        VirtualFile[] chosen = fileOrFolderChooser.choose(project = this.myProject);
        if (chosen.length > 0) {
            AsyncResult<List<SharedObjectFile>> callback = this.mySharedObjectFileFinder.findSharedObjectFiles(chosen, this.myLibrary, project);
            callback.doWhenDone(() -> {
                List result = (List)callback.getResult();
                assert (result != null);
                this.attachDebuggableSharedObjectFiles(result, chosen);
            });
            this.logAndNotifyIfRejected(callback);
        }
    }

    private void attachDebuggableSharedObjectFiles(@NotNull List<SharedObjectFile> files, @NotNull VirtualFile[] userSelection) {
        int fileCount = files.size();
        if (fileCount == 0) {
            this.notifyDebuggableSharedObjectFilesNotFound(userSelection);
            return;
        }
        this.attach(files, userSelection);
    }

    private void notifyDebuggableSharedObjectFilesNotFound(@NotNull VirtualFile[] userSelection) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Unable to find any debuggable shared object files from the selection:");
        for (VirtualFile file : userSelection) {
            buffer.append("<br/> - ").append(FileUtil.toSystemDependentName((String)file.getPath()));
        }
        String message = buffer.toString();
        LibraryEditorForm.getLog().warn(message);
        this.notifyUser(message, NotificationType.ERROR);
    }

    private void notifyUserAboutIgnoredFiles(@NotNull DebugSymbolsUpdater.UpdateResult result) {
        String message;
        StringBuilder buffer = new StringBuilder();
        if (!result.filesWithoutAbi.isEmpty()) {
            buffer.append("Unable to detect the ABI for file(s):<br/>");
            for (SharedObjectFile file : result.filesWithoutAbi) {
                buffer.append(" - ").append(file.getPath().getPath()).append("<br/>");
            }
        }
        if (!result.filesWithoutDebugSymbols.isEmpty()) {
            buffer.append("Unable to find debug symbols in file(s):<br/>");
            for (SharedObjectFile file : result.filesWithoutDebugSymbols) {
                buffer.append(" - ").append(file.getPath().getPath()).append("<br/>");
            }
        }
        if (!result.filesWithAbiMismatch.isEmpty()) {
            buffer.append("Unable to match ABI for file(s):<br/>");
            for (SharedObjectFile file : result.filesWithAbiMismatch) {
                buffer.append(" - ").append(file.getPath().getPath()).append("<br/>");
            }
        }
        if (!result.filesWithBuildIdMismatch.isEmpty()) {
            buffer.append("Unable to match build ID for file(s):<br/>");
            for (SharedObjectFile file : result.filesWithBuildIdMismatch) {
                buffer.append(" - ").append(file.getPath().getPath()).append("<br/>");
            }
        }
        if ((message = buffer.toString()).isEmpty()) {
            return;
        }
        LibraryEditorForm.getLog().warn(message);
        this.notifyUser(message, NotificationType.WARNING);
    }

    private void attach(@NotNull List<SharedObjectFile> files, @NotNull VirtualFile[] userSelection) {
        AsyncResult<DebugSymbolsUpdater.UpdateResult> callback = this.myDebugSymbolsUpdater.updateDebugSymbolsInLibrary(files, this.myLibrary, this.myApkFacet);
        callback.doWhenDone(() -> {
            DebugSymbolsUpdater.UpdateResult result = (DebugSymbolsUpdater.UpdateResult)callback.getResult();
            assert (result != null);
            this.notifyUserAboutIgnoredFiles(result);
            if (!result.addedFiles.isEmpty()) {
                this.myPathMappingsCleared = true;
                this.updateContents();
                this.updateSourceFolders();
            } else {
                this.notifyDebuggableSharedObjectFilesNotFound(userSelection);
            }
        });
        this.logAndNotifyIfRejected(callback);
    }

    private void logAndNotifyIfRejected(@NotNull AsyncResult<?> callback) {
        callback.doWhenRejected(() -> {
            Throwable error = callback.getUnexpectedError();
            if (error != null) {
                this.logAndNotify(error);
            }
        });
    }

    private void logAndNotify(@NotNull Throwable error) {
        String message = "Unexpected error: " + error.getMessage();
        LibraryEditorForm.getLog().warn(message, error);
        this.notifyUser(message, NotificationType.ERROR);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(LibraryEditorForm.class);
    }

    private void notifyUser(@NotNull String text, @NotNull NotificationType notificationType) {
        AndroidNotification.getInstance((Project)this.myProject).showBalloon(NOTIFICATION_TITLE, text, notificationType);
    }

    private void setFormBackground() {
        Color background = UIUtil.getTableBackground();
        this.myDebugSymbolsEditorForm.mainPanel.setBackground(background);
        this.myDebugSymbolsEditorForm.viewPanel.setBackground(background);
        this.myDebugSymbolsEditorForm.actionsPanel.setBackground(background);
        this.myDebugSymbolsEditorForm.addButton.setBackground(background);
        this.myDebugSymbolsEditorForm.clearButton.setBackground(background);
        this.myPathMappingEditorForm.mainPanel.setBackground(background);
        this.myPathMappingEditorForm.viewPanel.setBackground(background);
        this.myPathMappingEditorForm.actionsPanel.setBackground(background);
        this.myPathMappingEditorForm.clearButton.setBackground(background);
    }

    @VisibleForTesting
    void clearDebugSymbolsFilePaths() {
        String text = "This action will remove all the source folders containing native code. You will not be able to debug native code until you manually add debug symbols again.\nAre you sure you want to continue?";
        int clear = Messages.showYesNoDialog((Project)this.myProject, (String)text, (String)"Library Setup", (Icon)Messages.getQuestionIcon());
        if (clear == 0) {
            List sourceFolders = this.myLibrary.getSourceFolderPaths();
            AsyncResult<Void> callback = this.mySourceFoldersUpdater.removeSourceFolders(sourceFolders, this.myApkFacet.getModule());
            callback.doWhenDone(() -> {
                this.myLibrary.clearDebugSymbols();
                this.updateContents();
                this.myDebugSymbolNotifications.notifyLibraryUpdated(this.myApkFacet, this.myLibrary);
            });
            this.logAndNotifyIfRejected(callback);
        }
    }

    @VisibleForTesting
    void clearPathMappings() {
        boolean hasNdkPaths = false;
        Map pathMappings = this.myLibrary.pathMappings;
        for (Map.Entry entry : pathMappings.entrySet()) {
            entry.setValue("");
            if (hasNdkPaths || !this.myDebugSymbolsUpdater.isNdkPath((String)entry.getKey())) continue;
            hasNdkPaths = true;
        }
        if (hasNdkPaths) {
            String string;
            int mapNdkPaths;
            File ndkPath = null;
            if (this.myIdeSdks.getAndroidNdkPath() != null && (mapNdkPaths = Messages.showYesNoDialog((Project)this.myProject, (String)(string = "Do you want to have NDK paths automatically mapped?"), (String)"Path Mapping", (Icon)Messages.getQuestionIcon())) == 0) {
                ndkPath = this.myIdeSdks.getAndroidNdkPath();
            }
            this.myDebugSymbolsUpdater.updatePathMappingValues(this.myLibrary, pathMappings.keySet(), ndkPath);
        }
        this.myPathMappingsCleared = true;
        this.updateContents();
    }

    @VisibleForTesting
    void applyPathMappings() {
        Map<String, String> pathMappings = this.myPathMappingTableView.getEnteredPathMappings();
        if (!pathMappings.isEmpty()) {
            this.myLibrary.replacePathMappingsWith(pathMappings);
            this.updateSourceFolders();
            ApkDebuggingUsageTracker.logEvent(this.myApkFacet, AndroidStudioEvent.EventKind.APK_DEBUG_SELECT_PATH_MAPPINGS);
        }
        this.myPathMappingEditorForm.applyChangesLabel.setVisible(false);
    }

    private void updateSourceFolders() {
        AsyncResult<Void> callback = this.mySourceFoldersUpdater.updateSourceFolders(this.myApkFacet);
        callback.doWhenDone(() -> {
            this.updateContents();
            this.myDebugSymbolNotifications.notifyLibraryUpdated(this.myApkFacet, this.myLibrary);
        });
        this.logAndNotifyIfRejected(callback);
    }

    @VisibleForTesting
    void updateContents() {
        Runnable task = () -> {
            this.updateDebugSymbolStatus();
            this.updatePathMappingsStatus();
            this.myDebugSymbolsEditorForm.clearButton.setEnabled(!this.myLibrary.debuggableSharedObjectFilesByAbi.isEmpty());
            this.myDebugSymbolTableView.updateContents();
            this.myPathMappingTableView.updateContents();
            boolean clearActionEnabled = this.myLibrary.needsPathMappings() && !this.myLibrary.getUserSelectedPathsInMappings().isEmpty();
            this.myPathMappingEditorForm.clearButton.setEnabled(clearActionEnabled);
            this.myPathMappingEditorForm.applyChangesLabel.setVisible(this.myPathMappingsCleared && this.myLibrary.needsPathMappings());
            this.myContentsUpdated = true;
            this.myPathMappingsCleared = false;
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task.run();
        } else {
            application.invokeLater(task);
        }
    }

    boolean isContentsUpdated() {
        return this.myContentsUpdated;
    }

    private void updateDebugSymbolStatus() {
        String text;
        Icon icon;
        if (this.myLibrary.hasDebugSymbols) {
            icon = LibraryEditorForm.getGreenCheckIcon();
            text = "<html>The library already has debug symbols.</html>";
        } else {
            icon = LibraryEditorForm.getWarningIcon();
            text = "<html>The library is missing debug symbols. Please attach an external library file containing debug symbols.</html>";
        }
        this.myDebugSymbolsEditorForm.notificationLabel.setIcon(icon);
        this.myDebugSymbolsEditorForm.notificationLabel.setText(text);
    }

    @VisibleForTesting
    void updatePathMappingsStatus() {
        String text;
        Icon icon = LibraryEditorForm.getGreenCheckIcon();
        if (this.myLibrary.needsPathMappings()) {
            boolean missingPathMappings = this.myLibrary.isMissingPathMappings();
            if (missingPathMappings) {
                icon = LibraryEditorForm.getWarningIcon();
                text = "One or more debug symbols point to paths not found on this machine. Please map those paths to local ones.";
            } else {
                text = "All debug symbol paths are mapped to local paths.";
            }
        } else {
            text = "Path mappings are not needed.";
        }
        this.myPathMappingEditorForm.notificationLabel.setIcon(icon);
        this.myPathMappingEditorForm.notificationLabel.setText(text);
    }

    @VisibleForTesting
    @NotNull
    String getPathMappingsStatusText() {
        return this.myPathMappingEditorForm.notificationLabel.getText();
    }

    @NotNull
    private static Icon getWarningIcon() {
        return AllIcons.General.BalloonWarning;
    }

    @NotNull
    private static Icon getGreenCheckIcon() {
        return AllIcons.Debugger.ThreadStates.Idle;
    }

    @NotNull
    JPanel getMainPanel() {
        return this.mySplitter;
    }

    @VisibleForTesting
    @NotNull
    NativeLibrary getLibrary() {
        return this.myLibrary;
    }

    @NotNull
    Map<String, String> getDisplayedPathMappings() {
        return this.myPathMappingTableView.getEnteredPathMappings();
    }

    void updatePathMapping(@NotNull String originalPath, @NotNull String selectedPath) {
        this.myPathMappingTableView.updatePathMapping(originalPath, selectedPath);
    }

    static class FolderOrSharedObjectFileChooserFactory {
        static final String LAST_APK_SYMBOLS_LOCATION = "last.apk.symbols.location";
        PropertiesComponent myPropertiesComponent;
        VirtualFileSystem myVirtualFileSystem;

        @VisibleForTesting
        FolderOrSharedObjectFileChooserFactory(PropertiesComponent propertiesComponent, VirtualFileSystem virtualFileSystem) {
            this.myPropertiesComponent = propertiesComponent;
            this.myVirtualFileSystem = virtualFileSystem;
        }

        FolderOrSharedObjectFileChooserFactory() {
            this(PropertiesComponent.getInstance(), (VirtualFileSystem)LocalFileSystem.getInstance());
        }

        @NotNull
        FileOrFolderChooser create(@NotNull ApkFacet facet) {
            return project -> {
                SharedObjectFileChooserDescriptor descriptor = new SharedObjectFileChooserDescriptor(facet);
                FileChooserDialogImpl chooser = new FileChooserDialogImpl((FileChooserDescriptor)descriptor, project);
                VirtualFile lastSelectedFile = this.getLastApkSymbolsLocation();
                VirtualFile[] selectedFiles = chooser.choose(project, new VirtualFile[]{lastSelectedFile});
                this.setLastApkSymbolsLocation(selectedFiles);
                return selectedFiles;
            };
        }

        @VisibleForTesting
        @Nullable
        VirtualFile getLastApkSymbolsLocation() {
            String path = this.myPropertiesComponent.getValue(LAST_APK_SYMBOLS_LOCATION);
            if (path == null) {
                return null;
            }
            return this.myVirtualFileSystem.findFileByPath(path);
        }

        @VisibleForTesting
        void setLastApkSymbolsLocation(VirtualFile[] selectedFiles) {
            if (selectedFiles.length == 0) {
                return;
            }
            this.myPropertiesComponent.setValue(LAST_APK_SYMBOLS_LOCATION, selectedFiles[0].getPath());
        }
    }
}

