/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedObjectFileChooserDescriptor
extends FileChooserDescriptor {
    @Nullable
    private Condition<VirtualFile> myFilter;
    @VisibleForTesting
    static final int MAX_LISTED_LIBRARIES_SIZE = 10;

    public SharedObjectFileChooserDescriptor(@NotNull ApkFacet facet) {
        super(true, true, false, false, false, true);
        this.withFileFilter((Condition<VirtualFile>)((Condition)file -> file != null && "so".equals(file.getExtension())));
        this.setTitle("Debug Symbols");
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>Please select library files (*.so) containing debug symbols.<br/>");
        List libraries = ((ApkFacetConfiguration)facet.getConfiguration()).NATIVE_LIBRARIES;
        if (libraries.size() < 10) {
            buffer.append("The library file(s) to select must have the following name(s):<br/>");
            for (NativeLibrary library : ((ApkFacetConfiguration)facet.getConfiguration()).NATIVE_LIBRARIES) {
                buffer.append("&nbsp;*&nbsp;").append(library.name).append("<br/>");
            }
        }
        buffer.append("You can select library files or directories containing library files.</html>");
        this.setDescription(buffer.toString());
    }

    public FileChooserDescriptor withFileFilter(@Nullable Condition<VirtualFile> filter) {
        this.myFilter = filter;
        return super.withFileFilter(filter);
    }

    @Nullable
    Condition<VirtualFile> getFilter() {
        return this.myFilter;
    }
}

