/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.external.system;

import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.apk.external.system.ApkProjectSettings;
import com.android.tools.idea.apk.external.system.ApkProjectSettingsListener;
import com.android.tools.idea.apk.external.system.ApkSystemLocalSettings;
import com.android.tools.idea.apk.external.system.ApkSystemSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkSystemManager
implements ExternalSystemManager<ApkProjectSettings, ApkProjectSettingsListener, ApkSystemSettings, ApkSystemLocalSettings, ExternalSystemExecutionSettings> {
    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) throws ExecutionException {
    }

    @NotNull
    public ProjectSystemId getSystemId() {
        return ApkDebugging.SYSTEM_ID;
    }

    @NotNull
    public Function<Project, ApkSystemSettings> getSettingsProvider() {
        return ApkSystemSettings::getInstance;
    }

    @NotNull
    public Function<Project, ApkSystemLocalSettings> getLocalSettingsProvider() {
        return ApkSystemLocalSettings::getInstance;
    }

    @NotNull
    public Function<Pair<Project, String>, ExternalSystemExecutionSettings> getExecutionSettingsProvider() {
        return pair -> new ExternalSystemExecutionSettings();
    }

    @NotNull
    public Class<? extends ExternalSystemProjectResolver<ExternalSystemExecutionSettings>> getProjectResolverClass() {
        return ApkProjectResolverClass.class;
    }

    public Class<? extends ExternalSystemTaskManager<ExternalSystemExecutionSettings>> getTaskManagerClass() {
        return null;
    }

    @NotNull
    public FileChooserDescriptor getExternalProjectDescriptor() {
        return ApkSystemManager.createFileChooserDescriptor();
    }

    @NotNull
    private static FileChooserDescriptor createFileChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){
            FileChooserDescriptor myDelegate = new OpenProjectFileChooserDescriptor(true);

            public Icon getIcon(VirtualFile file) {
                Icon icon = this.myDelegate.getIcon(file);
                return icon == null ? super.getIcon(file) : icon;
            }
        };
        descriptor.setHideIgnored(false);
        descriptor.setTitle("Select APK File");
        descriptor.setDescription("Please select the APK file to debug.");
        descriptor.withFileFilter(file -> "apk".equals(file.getExtension()));
        return descriptor;
    }

    public static class ApkProjectResolverClass
    implements ExternalSystemProjectResolver<ExternalSystemExecutionSettings> {
        @Nullable
        public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, boolean isPreviewMode, @Nullable ExternalSystemExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
            return null;
        }

        public boolean cancelTask(@NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener) {
            return false;
        }
    }
}

