/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.issues;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.DebugSymbolsMissingReporter;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SdkNotFoundReporter;
import com.android.tools.idea.apk.issues.SetupIssueReportStrategy;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SetupIssueReporter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<IssueCategory, SetupIssueReportStrategy> myIssueReportStrategiesByCategory;

    @NotNull
    public static SetupIssueReporter getInstance(@NotNull Project project) {
        return (SetupIssueReporter)ServiceManager.getService((Project)project, SetupIssueReporter.class);
    }

    public SetupIssueReporter(@NotNull Project project, @NotNull IdeSdks ideSdks) {
        this(project, new SdkNotFoundReporter(ideSdks), new DebugSymbolsMissingReporter());
    }

    @VisibleForTesting
    SetupIssueReporter(@NotNull Project project, SetupIssueReportStrategy ... strategies) {
        this.myProject = project;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (SetupIssueReportStrategy strategy : strategies) {
            mapBuilder.put((Object)strategy.getSupportedCategory(), (Object)strategy);
        }
        this.myIssueReportStrategiesByCategory = mapBuilder.build();
    }

    public void reportSetupIssues(@NotNull ApkFacet facet) {
        Runnable task = () -> {
            ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)ApkDebugging.SYSTEM_ID);
            for (SetupIssue issue : ((ApkFacetConfiguration)facet.getConfiguration()).SETUP_ISSUES) {
                this.report(issue, facet);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task.run();
        } else {
            application.invokeLater(task);
        }
    }

    private void report(@NotNull SetupIssue issue, @NotNull ApkFacet facet) {
        IssueCategory category = IssueCategory.valueOf(issue.category);
        SetupIssueReportStrategy reportStrategy = this.myIssueReportStrategiesByCategory.get((Object)category);
        assert (reportStrategy != null);
        reportStrategy.report(this.myProject, issue, facet);
    }

    @VisibleForTesting
    @NotNull
    Map<IssueCategory, SetupIssueReportStrategy> getIssueReportStrategiesByCategory() {
        return this.myIssueReportStrategiesByCategory;
    }
}

