/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup;

import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.dex.DexFileDisassembler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectApkFileSetup {
    @NotNull
    private final DexFileDisassembler myDexFileDisassembler;

    public ProjectApkFileSetup() {
        this(new DexFileDisassembler());
    }

    @VisibleForTesting
    ProjectApkFileSetup(@NotNull DexFileDisassembler dexFileDisassembler) {
        this.myDexFileDisassembler = dexFileDisassembler;
    }

    @NotNull
    public Path setUpApk(@NotNull Path apkFilePath, @NotNull Path destination, @Nullable ProgressIndicator progressIndicator) throws IOException, ExecutionException, InterruptedException {
        Path newApkFile = Files.copy(apkFilePath, destination.resolve(apkFilePath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        Path smaliRootFolderPath = Files.createDirectory(destination.resolve("smali"), new FileAttribute[0]);
        if (progressIndicator != null) {
            progressIndicator.setText("Extracting contents");
        }
        try (ZipFile zipFile = new ZipFile(newApkFile.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            Splitter pathSplitter = Splitter.on((char)'/');
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                List segments = pathSplitter.omitEmptyStrings().splitToList((CharSequence)name);
                int segmentCount = segments.size();
                if (segmentCount == 0) {
                    this.getLog().warn("Found an entry with empty name in file '" + apkFilePath + "'");
                    continue;
                }
                String first = (String)segments.get(0);
                if (segmentCount > 1 && LibraryFolder.getName().equals(first) && name.endsWith(".so")) {
                    ProjectApkFileSetup.extract(entry, destination, zipFile);
                    continue;
                }
                if (segmentCount != 1 || !"classes.dex".equals(first)) continue;
                ProjectApkFileSetup.extract(entry, smaliRootFolderPath, zipFile);
            }
        }
        Path dexFilePath = smaliRootFolderPath.resolve("classes.dex");
        File expectedDexFilePath = dexFilePath.toFile();
        if (!expectedDexFilePath.isFile()) {
            throw new FileNotFoundException("Unable to find file '" + expectedDexFilePath.getPath() + "'");
        }
        Path outputFolderPath = Files.createDirectory(smaliRootFolderPath.resolve("out"), new FileAttribute[0]);
        if (progressIndicator != null) {
            progressIndicator.setText("Disassembling classes.dex");
        }
        this.myDexFileDisassembler.disassemble(expectedDexFilePath, outputFolderPath.toFile());
        return newApkFile;
    }

    @NotNull
    private Logger getLog() {
        return Logger.getInstance(this.getClass());
    }

    private static void extract(@NotNull ZipEntry entry, @NotNull Path destination, @NotNull ZipFile zipFile) throws IOException {
        ZipUtil.extractEntry((ZipEntry)entry, (InputStream)zipFile.getInputStream(entry), (File)destination.toFile(), (boolean)true);
    }
}

