/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.navigator.AndroidViewNodes;
import com.android.tools.idea.navigator.nodes.apk.ndk.LibFolderNode;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DebugSymbolNotifications {
    @NotNull
    private final AndroidViewNodes myAndroidViewNodes;

    @NotNull
    public static DebugSymbolNotifications getInstance() {
        return (DebugSymbolNotifications)ServiceManager.getService(DebugSymbolNotifications.class);
    }

    public DebugSymbolNotifications(@NotNull IdeSdks ideSdks) {
        this(new AndroidViewNodes());
    }

    DebugSymbolNotifications(@NotNull AndroidViewNodes androidViewNodes) {
        this.myAndroidViewNodes = androidViewNodes;
    }

    public void notifyLibraryUpdated(@NotNull ApkFacet facet, @NotNull NativeLibrary library) {
        this.notifyLibrariesUpdated(facet, Collections.singletonList(library));
    }

    public void notifyLibrariesUpdated(@NotNull ApkFacet facet, @NotNull List<NativeLibrary> libraries) {
        Project project = facet.getModule().getProject();
        ((ApkFacetConfiguration)facet.getConfiguration()).removeIssues(IssueCategory.DEBUG_SYMBOLS_MISSING.name());
        this.notifyIfDebugSymbolsAreMissing(facet, libraries);
        SetupIssueReporter.getInstance(project).reportSetupIssues(facet);
        this.myAndroidViewNodes.findAndRefreshNodeOfType(LibFolderNode.class, facet.getModule().getProject());
    }

    public void notifyIfDebugSymbolsAreMissing(@NotNull ApkFacet facet, @NotNull List<NativeLibrary> libraries) {
        ArrayList<NativeLibrary> toReport = new ArrayList<NativeLibrary>();
        for (NativeLibrary library : libraries) {
            if (library.hasDebugSymbols) continue;
            toReport.add(library);
        }
        if (!toReport.isEmpty()) {
            SetupIssue setupIssue = new SetupIssue();
            setupIssue.severity = MessageType.WARNING.name();
            setupIssue.category = IssueCategory.DEBUG_SYMBOLS_MISSING.name();
            ((ApkFacetConfiguration)facet.getConfiguration()).SETUP_ISSUES.add(setupIssue);
        }
    }
}

