/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.ndk.AbiFinder;
import com.android.tools.ndk.SourceRootsExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SharedObjectFileFinder {
    @NotNull
    private final AbiFinder myAbiFinder;
    @NotNull
    private final SourceRootsExtractor mySourceRootsExtractor;

    public SharedObjectFileFinder() {
        this(new AbiFinder(), new SourceRootsExtractor());
    }

    @VisibleForTesting
    SharedObjectFileFinder(@NotNull AbiFinder abiFinder, @NotNull SourceRootsExtractor sourceRootsExtractor) {
        this.myAbiFinder = abiFinder;
        this.mySourceRootsExtractor = sourceRootsExtractor;
    }

    @NotNull
    public AsyncResult<List<SharedObjectFile>> findSharedObjectFiles(final @NotNull VirtualFile[] files, final @NotNull NativeLibrary library, @NotNull Project project) {
        final AsyncResult<List<SharedObjectFile>> callback = new AsyncResult<List<SharedObjectFile>>();
        new Task.Modal(project, "Attach Debug Symbols", true){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText("Searching for debuggable shared object files");
                indicator.setIndeterminate(false);
                try {
                    List<SharedObjectFile> sharedObjectFiles = SharedObjectFileFinder.this.findSharedObjectFilesIn(files, library, indicator);
                    callback.setDone(sharedObjectFiles);
                }
                catch (Throwable error) {
                    callback.setRejected(error);
                }
            }
        }.queue();
        return callback;
    }

    @VisibleForTesting
    @NotNull
    List<SharedObjectFile> findSharedObjectFilesIn(@NotNull VirtualFile[] files, @NotNull NativeLibrary library, @NotNull ProgressIndicator indicator) throws IOException {
        ArrayList<SharedObjectFile> sharedObjectFiles = new ArrayList<SharedObjectFile>();
        int fileCount = files.length;
        for (int i = 0; i < fileCount; ++i) {
            indicator.setFraction((double)i / (double)fileCount);
            VirtualFile file = files[i];
            List<VirtualFile> filesToExamine = SharedObjectFileFinder.findSharedObjectFiles(file, library.name, indicator);
            for (VirtualFile fileToExamine : filesToExamine) {
                File pathToExamine = VfsUtilCore.virtualToIoFile((VirtualFile)fileToExamine);
                Abi abi = this.myAbiFinder.findAbi(pathToExamine);
                if (abi == null) {
                    sharedObjectFiles.add(new SharedObjectFile(fileToExamine, pathToExamine));
                    continue;
                }
                List debugSymbolPaths = this.mySourceRootsExtractor.extractSourceRoots(pathToExamine);
                sharedObjectFiles.add(new SharedObjectFile(fileToExamine, pathToExamine, abi, debugSymbolPaths));
            }
        }
        return sharedObjectFiles;
    }

    @NotNull
    private static List<VirtualFile> findSharedObjectFiles(@NotNull VirtualFile fileOrFolder, final @NotNull String libraryName, final @NotNull ProgressIndicator indicator) {
        final ArrayList<VirtualFile> filesToExamine = new ArrayList<VirtualFile>();
        if (fileOrFolder.isDirectory()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)fileOrFolder, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (indicator.isCanceled()) {
                        return false;
                    }
                    if (!file.isDirectory() && libraryName.equals(file.getName())) {
                        filesToExamine.add(file);
                        return false;
                    }
                    return true;
                }
            });
        } else {
            filesToExamine.add(fileOrFolder);
        }
        return filesToExamine;
    }
}

