/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.PsiNamesElementSignatureProvider;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.LightPlatformCodeInsightFixtureTestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPsiNamesElementSignatureProviderTest
extends LightPlatformCodeInsightFixtureTestCase {
    AbstractPsiNamesElementSignatureProviderTest() {
    }

    void doTest(@NotNull String text, @NotNull String ext) {
        this.myFixture.configureByText("test." + ext, text);
        CodeFoldingManager.getInstance((Project)this.getProject()).buildInitialFoldings(this.myFixture.getEditor());
        FoldRegion[] foldRegions = this.myFixture.getEditor().getFoldingModel().getAllFoldRegions();
        AbstractPsiNamesElementSignatureProviderTest.assertTrue((foldRegions.length > 1 ? 1 : 0) != 0);
        for (FoldRegion region : foldRegions) {
            PsiElement element = AbstractPsiNamesElementSignatureProviderTest.findElement(region, this.myFixture.getFile());
            if (element == null) continue;
            PsiNamesElementSignatureProvider provider2 = new PsiNamesElementSignatureProvider();
            String signature = provider2.getSignature(element);
            AbstractPsiNamesElementSignatureProviderTest.assertNotNull((Object)signature);
            AbstractPsiNamesElementSignatureProviderTest.assertEquals((Object)element, (Object)provider2.restoreBySignature(this.myFixture.getFile(), signature, null));
        }
    }

    @Nullable
    private static PsiElement findElement(@NotNull FoldRegion region, @NotNull PsiFile file) {
        return AbstractPsiNamesElementSignatureProviderTest.findElement(region.getStartOffset(), region.getEndOffset(), file);
    }

    @Nullable
    static PsiElement findElement(int startOffset, int endOffset, @NotNull PsiFile file) {
        for (PsiElement element = file.findElementAt(startOffset); element != null; element = element.getParent()) {
            TextRange range = element.getTextRange();
            if (range.getStartOffset() < startOffset) {
                return null;
            }
            if (range.getStartOffset() != startOffset || range.getEndOffset() != endOffset) continue;
            return element;
        }
        return null;
    }
}

