/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.compiler.CompileTaskBean;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.FileProcessingCompilerAdapterTask;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.OneProjectItemCompileScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.server.BuildManager;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFactory;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.CompilationPaths;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.ast.api.JavacFileData;

public class CompilerManagerImpl
extends CompilerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.CompilerManagerImpl");
    private final Project myProject;
    private final List<Compiler> myCompilers = new ArrayList<Compiler>();
    private final List<CompileTask> myBeforeTasks = new ArrayList<CompileTask>();
    private final List<CompileTask> myAfterTasks = new ArrayList<CompileTask>();
    private final Set<FileType> myCompilableTypes = new HashSet<FileType>();
    private final CompilationStatusListener myEventPublisher;
    private final Semaphore myCompilationSemaphore = new Semaphore(1, true);
    private final Set<ModuleType> myValidationDisabledModuleTypes = new HashSet<ModuleType>();
    private final Set<LocalFileSystem.WatchRequest> myWatchRoots;
    private volatile ExternalJavacManager myExternalJavacManager;
    private final Map<CompilationStatusListener, MessageBusConnection> myListenerAdapters = new HashMap<CompilationStatusListener, MessageBusConnection>();

    public CompilerManagerImpl(Project project2, MessageBus messageBus) {
        this.myProject = project2;
        this.myEventPublisher = (CompilationStatusListener)messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS);
        for (Compiler compiler : Compiler.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            this.addCompiler(compiler);
        }
        for (CompilerFactory factory : CompilerFactory.EP_NAME.getExtensionList((AreaInstance)project2)) {
            Compiler[] compilers;
            for (Compiler compiler : compilers = factory.createCompilers((CompilerManager)this)) {
                this.addCompiler(compiler);
            }
        }
        for (InspectionValidator validator2 : InspectionValidator.EP_NAME.getExtensionList((AreaInstance)project2)) {
            this.addCompiler((Compiler)new InspectionValidatorWrapper(this, InspectionManager.getInstance((Project)project2), InspectionProjectProfileManager.getInstance((Project)project2), PsiDocumentManager.getInstance((Project)project2), PsiManager.getInstance((Project)project2), validator2));
        }
        this.addCompilableFileType((FileType)StdFileTypes.JAVA);
        File projectGeneratedSrcRoot = CompilerPaths.getGeneratedDataDirectory((Project)project2);
        projectGeneratedSrcRoot.mkdirs();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        this.myWatchRoots = lfs.addRootsToWatch(Collections.singletonList(FileUtil.toCanonicalPath((String)projectGeneratedSrcRoot.getPath())), true);
        Disposer.register((Disposable)project2, () -> {
            ExternalJavacManager manager = this.myExternalJavacManager;
            this.myExternalJavacManager = null;
            if (manager != null) {
                manager.stop();
            }
            lfs.removeWatchedRoots(this.myWatchRoots);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                FileUtil.delete((File)CompilerPaths.getCompilerSystemDirectory((Project)project2));
            }
        });
    }

    public boolean waitForExternalJavacToTerminate(long time, @NotNull TimeUnit unit) {
        ExternalJavacManager externalJavacManager = this.myExternalJavacManager;
        return externalJavacManager == null || externalJavacManager.waitForAllProcessHandlers(time, unit);
    }

    public boolean awaitNettyThreadPoolTermination(long time, @NotNull TimeUnit unit) {
        ExternalJavacManager externalJavacManager = this.myExternalJavacManager;
        return externalJavacManager == null || externalJavacManager.awaitNettyThreadPoolTermination(time, unit);
    }

    public Semaphore getCompilationSemaphore() {
        return this.myCompilationSemaphore;
    }

    public boolean isCompilationActive() {
        return this.myCompilationSemaphore.availablePermits() == 0;
    }

    public final void addCompiler(@NotNull Compiler compiler) {
        this.myCompilers.add(compiler);
        if (compiler instanceof SourceInstrumentingCompiler) {
            this.addBeforeTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        } else if (compiler instanceof Validator) {
            this.addAfterTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        }
    }

    @Deprecated
    public void addTranslatingCompiler(@NotNull TranslatingCompiler compiler, Set<FileType> inputTypes, Set<FileType> outputTypes) {
    }

    public final void removeCompiler(@NotNull Compiler compiler) {
        for (List tasks2 : Arrays.asList(this.myBeforeTasks, this.myAfterTasks)) {
            tasks2.removeIf(task -> task instanceof FileProcessingCompilerAdapterTask && ((FileProcessingCompilerAdapterTask)task).getCompiler() == compiler);
        }
    }

    @NotNull
    public <T extends Compiler> T[] getCompilers(@NotNull Class<T> compilerClass) {
        return this.getCompilers(compilerClass, CompilerFilter.ALL);
    }

    @NotNull
    private <T extends Compiler> T[] getCompilers(@NotNull Class<T> compilerClass, CompilerFilter filter) {
        ArrayList<Compiler> compilers = new ArrayList<Compiler>(this.myCompilers.size());
        for (Compiler item : this.myCompilers) {
            if (!compilerClass.isAssignableFrom(item.getClass()) || !filter.acceptCompiler(item)) continue;
            compilers.add(item);
        }
        Compiler[] array = (Compiler[])Array.newInstance(compilerClass, compilers.size());
        return compilers.toArray(array);
    }

    public void addCompilableFileType(@NotNull FileType type) {
        this.myCompilableTypes.add(type);
    }

    public void removeCompilableFileType(@NotNull FileType type) {
        this.myCompilableTypes.remove(type);
    }

    public boolean isCompilableFileType(@NotNull FileType type) {
        return this.myCompilableTypes.contains(type);
    }

    public final void addBeforeTask(@NotNull CompileTask task) {
        this.myBeforeTasks.add(task);
    }

    public final void addAfterTask(@NotNull CompileTask task) {
        this.myAfterTasks.add(task);
    }

    @NotNull
    public List<CompileTask> getBeforeTasks() {
        return this.getCompileTasks(this.myBeforeTasks, CompileTaskBean.CompileTaskExecutionPhase.BEFORE);
    }

    @NotNull
    private List<CompileTask> getCompileTasks(@NotNull List<CompileTask> taskList, @NotNull CompileTaskBean.CompileTaskExecutionPhase phase) {
        ArrayList<CompileTask> beforeTasks = new ArrayList<CompileTask>(taskList);
        for (CompileTaskBean extension : CompileTaskBean.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            if (extension.myExecutionPhase != phase) continue;
            beforeTasks.add(extension.getTaskInstance(this.myProject));
        }
        return beforeTasks;
    }

    @NotNull
    public List<CompileTask> getAfterTaskList() {
        return this.getCompileTasks(this.myAfterTasks, CompileTaskBean.CompileTaskExecutionPhase.AFTER);
    }

    public void compile(@NotNull VirtualFile[] files, CompileStatusNotification callback) {
        this.compile(this.createFilesCompileScope(files), callback);
    }

    public void compile(@NotNull Module module2, CompileStatusNotification callback) {
        new CompileDriver(this.myProject).compile(this.createModuleCompileScope(module2, false), new ListenerNotificator(callback));
    }

    public void compile(@NotNull CompileScope scope, CompileStatusNotification callback) {
        new CompileDriver(this.myProject).compile(scope, new ListenerNotificator(callback));
    }

    public void make(CompileStatusNotification callback) {
        new CompileDriver(this.myProject).make(this.createProjectCompileScope(this.myProject), new ListenerNotificator(callback));
    }

    public void make(@NotNull Module module2, CompileStatusNotification callback) {
        new CompileDriver(this.myProject).make(this.createModuleCompileScope(module2, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull Project project2, @NotNull Module[] modules, CompileStatusNotification callback) {
        new CompileDriver(this.myProject).make(this.createModuleGroupCompileScope(project2, modules, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull CompileScope scope, CompileStatusNotification callback) {
        new CompileDriver(this.myProject).make(scope, new ListenerNotificator(callback));
    }

    public void makeWithModalProgress(@NotNull CompileScope scope, @Nullable CompileStatusNotification callback) {
        new CompileDriver(this.myProject).make(scope, true, new ListenerNotificator(callback));
    }

    public boolean isUpToDate(@NotNull CompileScope scope) {
        return new CompileDriver(this.myProject).isUpToDate(scope);
    }

    public void rebuild(CompileStatusNotification callback) {
        new CompileDriver(this.myProject).rebuild(new ListenerNotificator(callback));
    }

    public void executeTask(@NotNull CompileTask task, @NotNull CompileScope scope, String contentName, Runnable onTaskFinished) {
        CompileDriver compileDriver = new CompileDriver(this.myProject);
        compileDriver.executeCompileTask(task, scope, contentName, onTaskFinished);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener listener) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        this.myListenerAdapters.put(listener, connection);
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)listener);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener listener, @NotNull Disposable parentDisposable) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect(parentDisposable);
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)listener);
    }

    public void removeCompilationStatusListener(@NotNull CompilationStatusListener listener) {
        MessageBusConnection connection = this.myListenerAdapters.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public boolean isExcludedFromCompilation(@NotNull VirtualFile file) {
        return CompilerConfiguration.getInstance((Project)this.myProject).isExcludedFromCompilation(file);
    }

    @NotNull
    public CompileScope createFilesCompileScope(@NotNull VirtualFile[] files) {
        CompileScope[] scopes = new CompileScope[files.length];
        for (int i = 0; i < files.length; ++i) {
            scopes[i] = new OneProjectItemCompileScope(this.myProject, files[i]);
        }
        return new CompositeScope(scopes);
    }

    @NotNull
    public CompileScope createModuleCompileScope(@NotNull Module module2, boolean includeDependentModules) {
        return this.createModulesCompileScope(new Module[]{module2}, includeDependentModules);
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] modules, boolean includeDependentModules) {
        return this.createModulesCompileScope(modules, includeDependentModules, false);
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return new ModuleCompileScope(this.myProject, modules, includeDependentModules, includeRuntimeDependencies);
    }

    @NotNull
    public CompileScope createModuleGroupCompileScope(@NotNull Project project2, @NotNull Module[] modules, boolean includeDependentModules) {
        return new ModuleCompileScope(project2, modules, includeDependentModules);
    }

    @NotNull
    public CompileScope createProjectCompileScope(@NotNull Project project2) {
        return new ProjectCompileScope(project2);
    }

    public void setValidationEnabled(ModuleType moduleType, boolean enabled) {
        if (enabled) {
            this.myValidationDisabledModuleTypes.remove(moduleType);
        } else {
            this.myValidationDisabledModuleTypes.add(moduleType);
        }
    }

    public boolean isValidationEnabled(Module module2) {
        if (this.myValidationDisabledModuleTypes.isEmpty()) {
            return true;
        }
        return !this.myValidationDisabledModuleTypes.contains(ModuleType.get((Module)module2));
    }

    public Collection<ClassObject> compileJavaCode(List<String> options, Collection<File> platformCp, Collection<File> classpath, Collection<File> upgradeModulePath, Collection<File> modulePath, Collection<File> sourcePath, Collection<File> files, File outputDir) throws IOException, CompilationException {
        boolean compiledOk;
        Pair<Sdk, JavaSdkVersion> runtime = BuildManager.getJavacRuntimeSdk(this.myProject);
        Sdk sdk = (Sdk)runtime.getFirst();
        SdkTypeId type = sdk.getSdkType();
        String javaHome = null;
        if (type instanceof JavaSdkType && !CompilerManagerImpl.isJdkOrJre(javaHome = sdk.getHomePath())) {
            String binPath = ((JavaSdkType)type).getBinPath(sdk);
            String string = javaHome = binPath != null ? new File(binPath).getParent() : null;
            if (!CompilerManagerImpl.isJdkOrJre(javaHome)) {
                javaHome = null;
            }
        }
        if (javaHome == null) {
            throw new IOException("Was not able to determine JDK for project " + this.myProject.getName());
        }
        OutputCollector outputCollector = new OutputCollector();
        DiagnosticCollector diagnostic = new DiagnosticCollector();
        THashSet sourceRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        if (!sourcePath.isEmpty()) {
            sourceRoots.addAll(sourcePath);
        } else {
            for (File file : files) {
                File parentFile = file.getParentFile();
                if (parentFile == null) continue;
                sourceRoots.add(parentFile);
            }
        }
        Map<File, THashSet> outs = Collections.singletonMap(outputDir, sourceRoots);
        ExternalJavacManager javacManager = this.getJavacManager();
        CompilationPaths paths = CompilationPaths.create(platformCp, classpath, upgradeModulePath, modulePath, sourcePath);
        boolean bl = javacManager != null && javacManager.forkJavac(javaHome, -1, Collections.emptyList(), options, paths, files, outs, (DiagnosticOutputConsumer)diagnostic, (OutputFileConsumer)outputCollector, (JavaCompilingTool)new JavacCompilerTool(), CanceledStatus.NULL, !ApplicationManager.getApplication().isUnitTestMode()).get() != false ? true : (compiledOk = false);
        if (!compiledOk) {
            SmartList messages = new SmartList();
            for (Diagnostic<? extends JavaFileObject> d : diagnostic.getDiagnostics()) {
                JavaFileObject source = d.getSource();
                URI uri = source != null ? source.toUri() : null;
                messages.add(new CompilationException.Message(CompilerManagerImpl.kindToCategory(d.getKind()), d.getMessage(Locale.US), uri != null ? uri.toURL().toString() : null, (int)d.getLineNumber(), (int)d.getColumnNumber()));
            }
            throw new CompilationException("Compilation failed", (Collection)messages);
        }
        ArrayList<ClassObject> result = new ArrayList<ClassObject>();
        for (OutputFileObject fileObject : outputCollector.getCompiledClasses()) {
            BinaryContent content = fileObject.getContent();
            result.add(new CompiledClass(fileObject.getName(), fileObject.getClassName(), content != null ? content.toByteArray() : null));
        }
        return result;
    }

    private static boolean isJdkOrJre(@Nullable String path) {
        return path != null && (JdkUtil.checkForJre((String)path) || JdkUtil.checkForJdk((String)path));
    }

    private static CompilerMessageCategory kindToCategory(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return CompilerMessageCategory.ERROR;
            }
            case MANDATORY_WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case NOTE: {
                return CompilerMessageCategory.INFORMATION;
            }
        }
        return CompilerMessageCategory.INFORMATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ExternalJavacManager getJavacManager() throws IOException {
        ExternalJavacManager manager = this.myExternalJavacManager;
        if (manager == null) {
            CompilerManagerImpl compilerManagerImpl = this;
            synchronized (compilerManagerImpl) {
                manager = this.myExternalJavacManager;
                if (manager == null) {
                    File compilerWorkingDir = this.getJavacCompilerWorkingDir();
                    if (compilerWorkingDir == null) {
                        return null;
                    }
                    int listenPort = NetUtils.findAvailableSocketPort();
                    manager = new ExternalJavacManager(compilerWorkingDir, (Executor)ProcessIOExecutorService.INSTANCE, (long)Registry.intValue((String)"compiler.external.javac.keep.alive.timeout", (int)300000));
                    manager.start(listenPort);
                    this.myExternalJavacManager = manager;
                    IdeEventQueue.getInstance().addIdleListener((Runnable)new IdleTask(manager), 10000);
                }
            }
        }
        return manager;
    }

    @Nullable
    public File getJavacCompilerWorkingDir() {
        File projectBuildDir = BuildManager.getInstance().getProjectSystemDirectory(this.myProject);
        if (projectBuildDir == null) {
            return null;
        }
        projectBuildDir.mkdirs();
        return projectBuildDir;
    }

    private static class IdleTask
    implements Runnable {
        private static final int CHECK_PERIOD = 10000;
        private final ExternalJavacManager myManager;

        IdleTask(@NotNull ExternalJavacManager manager) {
            this.myManager = manager;
        }

        @Override
        public void run() {
            if (this.myManager.isRunning()) {
                this.myManager.shutdownIdleProcesses();
            } else {
                IdeEventQueue.getInstance().removeIdleListener((Runnable)this);
            }
        }
    }

    private static class OutputCollector
    implements OutputFileConsumer {
        private final List<OutputFileObject> myClasses = new ArrayList<OutputFileObject>();

        private OutputCollector() {
        }

        public void save(@NotNull OutputFileObject fileObject) {
            this.myClasses.add(fileObject);
        }

        List<OutputFileObject> getCompiledClasses() {
            return this.myClasses;
        }
    }

    private static class DiagnosticCollector
    implements DiagnosticOutputConsumer {
        private final List<Diagnostic<? extends JavaFileObject>> myDiagnostics = new ArrayList<Diagnostic<? extends JavaFileObject>>();

        private DiagnosticCollector() {
        }

        public void outputLineAvailable(String line) {
            if (line != null && line.startsWith("JAVAC_PROCESS[STDERR]")) {
                LOG.info(line.trim());
            }
        }

        public void registerJavacFileData(JavacFileData data) {
        }

        public void javaFileLoaded(File file) {
        }

        public void customOutputData(String pluginId, String dataName, byte[] data) {
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.myDiagnostics.add(diagnostic);
        }

        public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
            return this.myDiagnostics;
        }
    }

    private class ListenerNotificator
    implements CompileStatusNotification {
        @Nullable
        private final CompileStatusNotification myDelegate;

        private ListenerNotificator(CompileStatusNotification delegate) {
            this.myDelegate = delegate;
        }

        public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
            if (!CompilerManagerImpl.this.myProject.isDisposed()) {
                CompilerManagerImpl.this.myEventPublisher.compilationFinished(aborted, errors, warnings, compileContext);
            }
            if (this.myDelegate != null) {
                this.myDelegate.finished(aborted, errors, warnings, compileContext);
            }
        }
    }

    private static class CompiledClass
    implements ClassObject {
        private final String myPath;
        private final String myClassName;
        private final byte[] myBytes;

        CompiledClass(String path, String className, byte[] bytes) {
            this.myPath = path;
            this.myClassName = className;
            this.myBytes = bytes;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getClassName() {
            return this.myClassName;
        }

        @Nullable
        public byte[] getContent() {
            return this.myBytes;
        }

        public String toString() {
            return this.getClassName();
        }
    }
}

