/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.progress.CompilerTask;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProblemsView {
    protected final Project myProject;

    protected ProblemsView(Project project2) {
        this.myProject = project2;
    }

    public abstract void clearOldMessages(CompileScope var1, UUID var2);

    public abstract void addMessage(int var1, @NotNull String[] var2, @Nullable String var3, @Nullable Navigatable var4, @Nullable String var5, @Nullable String var6, @NotNull UUID var7);

    public final void addMessage(CompilerMessage message, @NotNull UUID sessionId) {
        VirtualFile file = message.getVirtualFile();
        Navigatable navigatable = message.getNavigatable();
        if (navigatable == null && file != null && !file.getFileType().isBinary()) {
            navigatable = new OpenFileDescriptor(this.myProject, file, -1, -1);
        }
        CompilerMessageCategory category = message.getCategory();
        int type = CompilerTask.translateCategory(category);
        String[] text = ProblemsView.convertMessage(message);
        String groupName = file != null ? file.getPresentableUrl() : category.getPresentableText();
        this.addMessage(type, text, groupName, navigatable, message.getExportTextPrefix(), message.getRenderTextPrefix(), sessionId);
    }

    public abstract void setProgress(String var1, float var2);

    public abstract void setProgress(String var1);

    public abstract void clearProgress();

    private static String[] convertMessage(CompilerMessage message) {
        String text = message.getMessage();
        if (!text.contains("\n")) {
            return new String[]{text};
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return ArrayUtil.toStringArray(lines);
    }

    public static class SERVICE {
        private SERVICE() {
        }

        public static ProblemsView getInstance(Project project2) {
            return (ProblemsView)ServiceManager.getService((Project)project2, ProblemsView.class);
        }
    }
}

