/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.ZipFileSet;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import org.jetbrains.annotations.NotNull;

public class ArchiveAntCopyInstructionCreator
implements AntCopyInstructionCreator {
    private final String myPrefix;

    public ArchiveAntCopyInstructionCreator(String prefix) {
        this.myPrefix = prefix;
    }

    @NotNull
    public Tag createDirectoryContentCopyInstruction(@NotNull String dirPath) {
        return new ZipFileSet(dirPath, this.myPrefix, true);
    }

    @NotNull
    public Tag createFileCopyInstruction(@NotNull String filePath2, String outputFileName) {
        String relativePath = this.myPrefix + "/" + outputFileName;
        return new ZipFileSet(filePath2, relativePath, false);
    }

    @NotNull
    public AntCopyInstructionCreator subFolder(@NotNull String directoryName) {
        return new ArchiveAntCopyInstructionCreator(this.myPrefix + "/" + directoryName);
    }

    public Generator createSubFolderCommand(@NotNull String directoryName) {
        return null;
    }

    @NotNull
    public Generator createExtractedDirectoryInstruction(@NotNull String jarPath) {
        return ZipFileSet.createUnpackedSet((String)jarPath, (String)this.myPrefix, (boolean)true);
    }
}

