/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.StorageException;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;

public abstract class CompilerReferenceReader<Index extends CompilerReferenceIndex<?>> {
    protected final Index myIndex;
    protected final File myBuildDir;

    public CompilerReferenceReader(File buildDir, Index index) {
        this.myIndex = index;
        this.myBuildDir = buildDir;
    }

    @NotNull
    public NameEnumerator getNameEnumerator() {
        return this.myIndex.getByteSeqEum();
    }

    public void close(boolean removeIndex) {
        this.myIndex.close();
        if (removeIndex) {
            CompilerReferenceIndex.removeIndexFiles((File)this.myBuildDir);
        }
    }

    public Index getIndex() {
        return this.myIndex;
    }

    @Nullable
    public abstract TIntHashSet findReferentFileIds(@NotNull CompilerRef var1, boolean var2) throws StorageException;

    @Nullable
    public abstract TIntHashSet findFileIdsWithImplicitToString(@NotNull CompilerRef var1) throws StorageException;

    @Nullable
    public abstract Map<VirtualFile, SearchId[]> getDirectInheritors(@NotNull CompilerRef var1, @NotNull GlobalSearchScope var2, @NotNull GlobalSearchScope var3, @NotNull FileType var4, @NotNull CompilerHierarchySearchType var5) throws StorageException;

    @Nullable
    public abstract Integer getAnonymousCount(@NotNull CompilerRef.CompilerClassHierarchyElementDef var1, boolean var2);

    public abstract int getOccurrenceCount(@NotNull CompilerRef var1);

    @Nullable(value="return null if the class hierarchy contains ambiguous qualified names")
    public abstract CompilerRef.CompilerClassHierarchyElementDef[] getHierarchy(CompilerRef.CompilerClassHierarchyElementDef var1, boolean var2, boolean var3, int var4);
}

