/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerHierarchyInfoImpl;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceReaderFactory;
import com.intellij.compiler.backwardRefs.DirtyScopeHolder;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.server.BuildManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;

public abstract class CompilerReferenceServiceBase<Reader extends CompilerReferenceReader<?>>
implements CompilerReferenceService,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceServiceBase.class);
    protected final Set<FileType> myFileTypes;
    protected final DirtyScopeHolder myDirtyScopeHolder;
    protected final ProjectFileIndex myProjectFileIndex;
    protected final LongAdder myCompilationCount = new LongAdder();
    protected final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    protected final Lock myReadDataLock = this.myLock.readLock();
    protected final Lock myOpenCloseLock = this.myLock.writeLock();
    protected final Project myProject;
    protected final CompilerReferenceReaderFactory<? extends Reader> myReaderFactory;
    protected int myActiveBuilds = 0;
    protected volatile Reader myReader;

    public CompilerReferenceServiceBase(Project project2, FileDocumentManager fileDocumentManager, PsiDocumentManager psiDocumentManager, CompilerReferenceReaderFactory<? extends Reader> readerFactory, BiConsumer<MessageBusConnection, Set<String>> compilationAffectedModulesSubscription) {
        this.myProject = project2;
        this.myReaderFactory = readerFactory;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.myFileTypes = Stream.of(LanguageCompilerRefAdapter.INSTANCES).flatMap(a -> a.getFileTypes().stream()).collect(Collectors.toSet());
        this.myDirtyScopeHolder = new DirtyScopeHolder(this, fileDocumentManager, psiDocumentManager, compilationAffectedModulesSubscription);
    }

    public void projectOpened() {
        if (CompilerReferenceService.isEnabled()) {
            this.myDirtyScopeHolder.installVFSListener();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    boolean isUpToDate;
                    boolean validIndexExists;
                    File buildDir = BuildManager.getInstance().getProjectSystemDirectory(this.myProject);
                    boolean bl = validIndexExists = buildDir != null && CompilerReferenceIndex.exists((File)buildDir) && !CompilerReferenceIndex.versionDiffers((File)buildDir, (int)this.myReaderFactory.expectedIndexVersion());
                    if (validIndexExists) {
                        CompileScope projectCompileScope = compilerManager.createProjectCompileScope(this.myProject);
                        isUpToDate = compilerManager.isUpToDate(projectCompileScope);
                    } else {
                        isUpToDate = false;
                    }
                    CompilerReferenceServiceBase.executeOnBuildThread(() -> {
                        if (isUpToDate) {
                            this.openReaderIfNeed(IndexOpenReason.UP_TO_DATE_CACHE);
                        } else {
                            this.markAsOutdated(validIndexExists);
                        }
                    });
                });
            }
            Disposer.register((Disposable)this.myProject, () -> this.closeReaderIfNeed(IndexCloseReason.PROJECT_CLOSED));
        }
    }

    @Nullable
    public GlobalSearchScope getScopeWithoutCodeReferences(@NotNull PsiElement element) {
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)this.buildScopeWithoutReferences(this.getReferentFileIds(element)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
        }
        catch (RuntimeException e1) {
            return (GlobalSearchScope)this.onException(e1, "scope without code references");
        }
    }

    @Nullable
    public GlobalSearchScope getScopeWithoutImplicitToStringCodeReferences(@NotNull PsiElement aClass) {
        if (!this.isServiceEnabledFor(aClass)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)this.buildScopeWithoutReferences(this.getReferentFileIdsViaImplicitToString(aClass)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
        }
        catch (RuntimeException e1) {
            return (GlobalSearchScope)this.onException(e1, "scope without implicit toString references");
        }
    }

    @Nullable
    public CompilerDirectHierarchyInfo getDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        return this.getHierarchyInfo(aClass, searchScope, searchFileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
    }

    @Nullable
    public CompilerDirectHierarchyInfo getFunExpressions(@NotNull PsiNamedElement functionalInterface, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        return this.getHierarchyInfo(functionalInterface, searchScope, searchFileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
    }

    @Nullable
    public Integer getCompileTimeOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (Integer)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(constructorSuggestion -> this.calculateOccurrenceCount(element, (boolean)constructorSuggestion)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}))).get(isConstructorSuggestion);
        }
        catch (RuntimeException e) {
            return (Integer)this.onException(e, "weighting for completion");
        }
    }

    protected Integer calculateOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        LanguageCompilerRefAdapter adapter = null;
        if (isConstructorSuggestion && ((adapter = (LanguageCompilerRefAdapter)ReadAction.compute(() -> LanguageCompilerRefAdapter.findAdapter(element))) == null || !adapter.isClass(element))) {
            return null;
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements(element, false, false);
        if (searchElementInfo == null) {
            return null;
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Integer n = null;
                return n;
            }
            if (isConstructorSuggestion) {
                int constructorOccurrences = 0;
                for (PsiElement constructor : adapter.getInstantiableConstructors(element)) {
                    CompilerRef constructorRef = adapter.asCompilerRef(constructor, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
                    if (constructorRef == null) continue;
                    constructorOccurrences += ((CompilerReferenceReader)this.myReader).getOccurrenceCount(constructorRef);
                }
                Integer anonymousCount = ((CompilerReferenceReader)this.myReader).getAnonymousCount((CompilerRef.CompilerClassHierarchyElementDef)searchElementInfo.searchElements[0], searchElementInfo.place == ElementPlace.SRC);
                Integer n = anonymousCount == null ? constructorOccurrences : constructorOccurrences + anonymousCount;
                return n;
            }
            Integer constructorOccurrences = ((CompilerReferenceReader)this.myReader).getOccurrenceCount(searchElementInfo.searchElements[0]);
            return constructorOccurrences;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected CompilerHierarchyInfoImpl getHierarchyInfo(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        if (!this.isServiceEnabledFor((PsiElement)aClass) || searchScope == LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope()) {
            return null;
        }
        try {
            Map candidatesPerFile = (Map)ReadAction.compute(() -> {
                if (this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (Map)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(key -> this.calculateDirectInheritors(aClass, ((HierarchySearchKey)key).mySearchFileType, ((HierarchySearchKey)key).mySearchType)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}))).get(new HierarchySearchKey(searchType, searchFileType));
            });
            if (candidatesPerFile == null) {
                return null;
            }
            GlobalSearchScope dirtyScope = this.myDirtyScopeHolder.getDirtyScope();
            if (ElementPlace.LIB == ReadAction.compute(() -> ElementPlace.get(aClass.getContainingFile().getVirtualFile(), this.myProjectFileIndex))) {
                dirtyScope = dirtyScope.union((SearchScope)LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope());
            }
            return new CompilerHierarchyInfoImpl(candidatesPerFile, aClass, dirtyScope, searchScope, this.myProject, searchFileType, searchType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return (CompilerHierarchyInfoImpl)this.onException(e, "hierarchy");
        }
    }

    protected boolean isServiceEnabledFor(PsiElement element) {
        if (!this.isActive()) {
            return false;
        }
        PsiFile file = (PsiFile)ReadAction.compute(() -> element.getContainingFile());
        return file != null && !InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(file);
    }

    public boolean isActive() {
        return this.myReader != null && CompilerReferenceService.isEnabled();
    }

    protected Map<VirtualFile, SearchId[]> calculateDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        SearchScope scope = aClass.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements((PsiElement)aClass, false, true);
        if (searchElementInfo == null) {
            return null;
        }
        CompilerRef searchElement = searchElementInfo.searchElements[0];
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Map<VirtualFile, SearchId[]> map2 = null;
                return map2;
            }
            Map<VirtualFile, SearchId[]> map3 = ((CompilerReferenceReader)this.myReader).getDirectInheritors(searchElement, (GlobalSearchScope)scope, this.myDirtyScopeHolder.getDirtyScope(), searchFileType, searchType);
            return map3;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected GlobalSearchScope buildScopeWithoutReferences(@Nullable TIntHashSet referentFileIds) {
        if (referentFileIds == null) {
            return null;
        }
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)new ScopeWithoutReferencesOnCompilation(referentFileIds, this.myProjectFileIndex).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.myDirtyScopeHolder.getDirtyScope())), (FileType[])this.myFileTypes.toArray(FileType.EMPTY_ARRAY));
    }

    @Nullable
    protected TIntHashSet getReferentFileIds(@NotNull PsiElement element) {
        return this.getReferentFileIds(element, true, (ref, elementPlace) -> ((CompilerReferenceReader)this.myReader).findReferentFileIds(ref, elementPlace == ElementPlace.SRC));
    }

    @Nullable
    protected TIntHashSet getReferentFileIdsViaImplicitToString(@NotNull PsiElement element) {
        return this.getReferentFileIds(element, false, (ref, elementPlace) -> ((CompilerReferenceReader)this.myReader).findFileIdsWithImplicitToString(ref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected TIntHashSet getReferentFileIds(@NotNull PsiElement element, boolean buildHierarchyForLibraryElements, @NotNull ReferentFileSearcher referentFileSearcher) {
        CompilerElementInfo compilerElementInfo = this.asCompilerElements(element, buildHierarchyForLibraryElements, true);
        if (compilerElementInfo == null) {
            return null;
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                TIntHashSet tIntHashSet = null;
                return tIntHashSet;
            }
            TIntHashSet referentFileIds = new TIntHashSet();
            for (TIntHashSet ref : compilerElementInfo.searchElements) {
                TIntHashSet referents;
                block12: {
                    try {
                        referents = referentFileSearcher.findReferentFiles((CompilerRef)ref, compilerElementInfo.place);
                        if (referents != null) break block12;
                        TIntHashSet tIntHashSet = null;
                        return tIntHashSet;
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
                referentFileIds.addAll(referents.toArray());
            }
            TIntHashSet tIntHashSet = referentFileIds;
            return tIntHashSet;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected CompilerElementInfo asCompilerElements(@NotNull PsiElement psiElement, boolean buildHierarchyForLibraryElements, boolean checkNotDirty) {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (file == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            ElementPlace place = ElementPlace.get(file, this.myProjectFileIndex);
            if (checkNotDirty && (place == null || place == ElementPlace.SRC && this.myDirtyScopeHolder.contains(file))) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LanguageCompilerRefAdapter adapter = LanguageCompilerRefAdapter.findAdapter(file);
            if (adapter == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            CompilerRef ref = adapter.asCompilerRef(psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
            if (ref == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            if (place == ElementPlace.LIB && buildHierarchyForLibraryElements) {
                List<CompilerRef> elements = adapter.getHierarchyRestrictedToLibraryScope(ref, psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator(), LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope());
                CompilerRef[] fullHierarchy = new CompilerRef[elements.size() + 1];
                fullHierarchy[0] = ref;
                int i = 1;
                for (CompilerRef element : elements) {
                    fullHierarchy[i++] = element;
                }
                CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, fullHierarchy);
                return compilerElementInfo;
            }
            CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, ref);
            return compilerElementInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    protected void closeReaderIfNeed(IndexCloseReason reason) {
        this.myOpenCloseLock.lock();
        try {
            if (reason == IndexCloseReason.COMPILATION_STARTED) {
                ++this.myActiveBuilds;
                this.myDirtyScopeHolder.compilerActivityStarted();
            }
            if (this.myReader != null) {
                ((CompilerReferenceReader)this.myReader).close(reason == IndexCloseReason.AN_EXCEPTION);
                this.myReader = null;
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    protected void openReaderIfNeed(IndexOpenReason reason) {
        this.myCompilationCount.increment();
        this.myOpenCloseLock.lock();
        try {
            try {
                switch (reason) {
                    case UP_TO_DATE_CACHE: {
                        this.myDirtyScopeHolder.upToDateChecked(true);
                        break;
                    }
                    case COMPILATION_FINISHED: {
                        this.myDirtyScopeHolder.compilerActivityFinished();
                    }
                }
            }
            catch (RuntimeException e) {
                --this.myActiveBuilds;
                throw e;
            }
            if (--this.myActiveBuilds == 0 && this.myProject.isOpen()) {
                this.myReader = this.myReaderFactory.create(this.myProject);
                LOG.info("backward reference index reader " + (this.myReader == null ? "doesn't exist" : "is opened"));
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    protected void markAsOutdated(boolean decrementBuildCount) {
        this.myOpenCloseLock.lock();
        try {
            if (decrementBuildCount) {
                --this.myActiveBuilds;
            }
            this.myDirtyScopeHolder.upToDateChecked(false);
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    public ProjectFileIndex getFileIndex() {
        return this.myProjectFileIndex;
    }

    public Set<FileType> getFileTypes() {
        return this.myFileTypes;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected static void executeOnBuildThread(Runnable compilationFinished) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            compilationFinished.run();
        } else {
            BuildManager.getInstance().runCommand(compilationFinished);
        }
    }

    public long getModificationCount() {
        return this.myCompilationCount.longValue();
    }

    @Nullable
    public Set<VirtualFile> getReferentFiles(@NotNull PsiElement element) {
        FileBasedIndex fileIndex = FileBasedIndex.getInstance();
        TIntHashSet ids = this.getReferentFileIds(element);
        if (ids == null) {
            return null;
        }
        THashSet fileSet = new THashSet();
        ids.forEach(arg_0 -> this.lambda$getReferentFiles$16(fileIndex, (Set)fileSet, arg_0));
        return fileSet;
    }

    @NotNull
    DirtyScopeHolder getDirtyScopeHolder() {
        return this.myDirtyScopeHolder;
    }

    public Set<Module> getAllDirtyModulesForTest() {
        return this.myDirtyScopeHolder.getAllDirtyModulesForTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceFindUsagesTestInfo getTestFindUsages(@NotNull PsiElement element) {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            TIntHashSet referentFileIds = this.getReferentFileIds(element);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo = new CompilerReferenceFindUsagesTestInfo(referentFileIds, dirtyScopeInfo, this.myProject);
            return compilerReferenceFindUsagesTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceHierarchyTestInfo getTestHierarchy(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
            return compilerReferenceHierarchyTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceHierarchyTestInfo getTestFunExpressions(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
            return compilerReferenceHierarchyTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected <T> T onException(@NotNull Exception e, @NotNull String actionName) {
        Throwable unwrapped;
        if (e instanceof ControlFlowException) {
            throw (RuntimeException)e;
        }
        LOG.error("an exception during " + actionName + " calculation", (Throwable)e);
        Throwable throwable = unwrapped = e instanceof RuntimeException ? e.getCause() : e;
        if (CompilerReferenceServiceBase.requireIndexRebuild(unwrapped)) {
            this.closeReaderIfNeed(IndexCloseReason.AN_EXCEPTION);
        }
        return null;
    }

    @NotNull
    protected static TIntHashSet intersection(@NotNull TIntHashSet set1, @NotNull TIntHashSet set2) {
        TIntHashSet result = (TIntHashSet)set1.clone();
        result.retainAll(set2.toArray());
        return result;
    }

    protected static boolean requireIndexRebuild(@Nullable Throwable exception) {
        return exception instanceof StorageException || exception instanceof IOException;
    }

    private /* synthetic */ boolean lambda$getReferentFiles$16(FileBasedIndex fileIndex, Set fileSet, int id) {
        VirtualFile vFile = fileIndex.findFileById(this.myProject, id);
        assert (vFile != null);
        fileSet.add(vFile);
        return true;
    }

    @FunctionalInterface
    protected static interface ReferentFileSearcher {
        @Nullable
        public TIntHashSet findReferentFiles(@NotNull CompilerRef var1, @NotNull ElementPlace var2) throws StorageException;
    }

    protected static enum IndexOpenReason {
        COMPILATION_FINISHED,
        UP_TO_DATE_CACHE;

    }

    protected static enum IndexCloseReason {
        AN_EXCEPTION,
        COMPILATION_STARTED,
        PROJECT_CLOSED;

    }

    protected static class HierarchySearchKey {
        private final CompilerHierarchySearchType mySearchType;
        private final FileType mySearchFileType;

        public HierarchySearchKey(CompilerHierarchySearchType searchType, FileType searchFileType) {
            this.mySearchType = searchType;
            this.mySearchFileType = searchFileType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HierarchySearchKey key = (HierarchySearchKey)o;
            return this.mySearchType == key.mySearchType && this.mySearchFileType == key.mySearchFileType;
        }

        public int hashCode() {
            return 31 * this.mySearchType.hashCode() + this.mySearchFileType.hashCode();
        }
    }

    protected static class CompilerElementInfo {
        public final ElementPlace place;
        public final CompilerRef[] searchElements;

        public CompilerElementInfo(ElementPlace place, CompilerRef ... searchElements) {
            this.place = place;
            this.searchElements = searchElements;
        }
    }

    protected static class ScopeWithoutReferencesOnCompilation
    extends GlobalSearchScope {
        private final TIntHashSet myReferentIds;
        private final ProjectFileIndex myIndex;

        public ScopeWithoutReferencesOnCompilation(TIntHashSet ids, ProjectFileIndex index) {
            this.myReferentIds = ids;
            this.myIndex = index;
        }

        public boolean contains(@NotNull VirtualFile file) {
            return file instanceof VirtualFileWithId && this.myIndex.isInSourceContent(file) && !this.myReferentIds.contains(((VirtualFileWithId)file).getId());
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    protected static enum ElementPlace {
        SRC,
        LIB;


        public static ElementPlace get(VirtualFile file, ProjectFileIndex index) {
            if (file == null) {
                return null;
            }
            return index.isInSourceContent(file) ? SRC : (index.isInLibrary(file) ? LIB : null);
        }
    }
}

