/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceBase;
import com.intellij.compiler.backwardRefs.ExcludedFromCompileFilesUtil;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class DirtyScopeHolder
extends UserDataHolderBase
implements BulkFileListener {
    private final CompilerReferenceServiceBase<?> myService;
    private final FileDocumentManager myFileDocManager;
    private final PsiDocumentManager myPsiDocManager;
    private final Object myLock = new Object();
    private final Set<Module> myVFSChangedModules = ContainerUtil.newHashSet();
    private final Set<Module> myChangedModulesDuringCompilation = ContainerUtil.newHashSet();
    private final List<ExcludeEntryDescription> myExcludedDescriptions = new SmartList();
    private boolean myCompilationPhase;
    private volatile GlobalSearchScope myExcludedFilesScope;
    private final Set<String> myCompilationAffectedModules = ContainerUtil.newConcurrentSet();
    private final FileTypeRegistry myFileTypeRegistry = FileTypeRegistry.getInstance();

    DirtyScopeHolder(@NotNull CompilerReferenceServiceBase<?> service, @NotNull FileDocumentManager fileDocumentManager, @NotNull PsiDocumentManager psiDocumentManager, @NotNull BiConsumer<? super MessageBusConnection, ? super Set<String>> compilationAffectedModulesSubscription) {
        this.myService = service;
        this.myFileDocManager = fileDocumentManager;
        this.myPsiDocManager = psiDocumentManager;
        if (CompilerReferenceService.isEnabled()) {
            MessageBusConnection connect = service.getProject().getMessageBus().connect();
            connect.subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEntryAdded(@NotNull ExcludeEntryDescription description) {
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        if (DirtyScopeHolder.this.myCompilationPhase) {
                            DirtyScopeHolder.this.myExcludedDescriptions.add(description);
                        }
                    }
                }
            });
            compilationAffectedModulesSubscription.accept((MessageBusConnection)connect, this.myCompilationAffectedModules);
            connect.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                    Object[] modules = ModuleManager.getInstance((Project)DirtyScopeHolder.this.myService.getProject()).getModules();
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        ContainerUtil.addAll((Collection)DirtyScopeHolder.this.myVFSChangedModules, (Object[])modules);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compilerActivityStarted() {
        ExcludeEntryDescription[] excludeEntryDescriptions = CompilerConfiguration.getInstance((Project)this.myService.getProject()).getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = true;
            Collections.addAll(this.myExcludedDescriptions, excludeEntryDescriptions);
            this.myExcludedFilesScope = null;
            this.myCompilationAffectedModules.clear();
        }
    }

    public void upToDateChecked(boolean isUpToDate) {
        Module[] modules = (Module[])ReadAction.compute(() -> {
            Project project2 = this.myService.getProject();
            if (project2.isDisposed()) {
                return null;
            }
            return ModuleManager.getInstance((Project)project2).getModules();
        });
        if (modules == null) {
            return;
        }
        this.compilationFinished(() -> {
            if (!isUpToDate) {
                ContainerUtil.addAll(this.myVFSChangedModules, (Object[])modules);
            }
        });
    }

    void compilerActivityFinished() {
        List compiledModules = (List)ReadAction.compute(() -> {
            Project project2 = this.myService.getProject();
            if (project2.isDisposed()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myService.getProject());
            return ContainerUtil.map(this.myCompilationAffectedModules, arg_0 -> ((ModuleManager)moduleManager).findModuleByName(arg_0));
        });
        this.compilationFinished(() -> {
            if (compiledModules == null) {
                return;
            }
            this.myVFSChangedModules.removeAll(compiledModules);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compilationFinished(@NotNull Runnable action) {
        ExcludeEntryDescription[] descriptions;
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = false;
            action.run();
            this.myVFSChangedModules.addAll(this.myChangedModulesDuringCompilation);
            this.myChangedModulesDuringCompilation.clear();
            descriptions = this.myExcludedDescriptions.toArray(new ExcludeEntryDescription[0]);
            this.myExcludedDescriptions.clear();
        }
        this.myCompilationAffectedModules.clear();
        this.myExcludedFilesScope = ExcludedFromCompileFilesUtil.getExcludedFilesScope(descriptions, this.myService.getFileTypes(), this.myService.getProject(), this.myService.getFileIndex());
    }

    @NotNull
    public GlobalSearchScope getDirtyScope() {
        Project project2 = this.myService.getProject();
        return (GlobalSearchScope)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myCompilationPhase) {
                    return GlobalSearchScope.allScope((Project)project2);
                }
                if (project2.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (GlobalSearchScope)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.calculateDirtyScope(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.getInstance(), this.myService}));
            }
        });
    }

    @NotNull
    private GlobalSearchScope calculateDirtyScope() {
        Set<Module> dirtyModules = this.getAllDirtyModules();
        if (dirtyModules.isEmpty()) {
            return this.myExcludedFilesScope;
        }
        GlobalSearchScope dirtyModuleScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])dirtyModules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
        return dirtyModuleScope.union((SearchScope)this.myExcludedFilesScope);
    }

    @NotNull
    public Set<Module> getAllDirtyModules() {
        THashSet dirtyModules = new THashSet(this.myVFSChangedModules);
        for (Document document2 : this.myFileDocManager.getUnsavedDocuments()) {
            Module m;
            VirtualFile file = this.myFileDocManager.getFile(document2);
            if (file == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        for (Document document2 : this.myPsiDocManager.getUncommittedDocuments()) {
            Module m;
            VirtualFile file;
            PsiFile psiFile = this.myPsiDocManager.getPsiFile(document2);
            if (psiFile == null || (file = psiFile.getVirtualFile()) == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        return dirtyModules;
    }

    public boolean contains(@NotNull VirtualFile file) {
        return this.getDirtyScope().contains(file);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            VFilePropertyChangeEvent pce;
            String propertyName;
            if (vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileMoveEvent) {
                VirtualFile file = vFileEvent.getFile();
                if (file == null) continue;
                this.fileChanged(file);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(propertyName = (pce = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(propertyName)) continue;
            this.fileChanged(pce.getFile());
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            VFilePropertyChangeEvent pce;
            String propertyName;
            if (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileContentChangeEvent) {
                VirtualFile file = vFileEvent.getFile();
                this.fileChanged(file);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(propertyName = (pce = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(propertyName)) continue;
            String path = pce.getFile().getPath();
            for (Module module2 : ModuleManager.getInstance((Project)this.myService.getProject()).getModules()) {
                if (!FileUtil.isAncestor((String)path, (String)module2.getModuleFilePath(), (boolean)true)) continue;
                this.addToDirtyModules(module2);
            }
        }
    }

    public void installVFSListener() {
        this.myService.getProject().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
    }

    private void fileChanged(@NotNull VirtualFile file) {
        Module module2 = this.getModuleForSourceContentFile(file);
        if (module2 != null) {
            this.addToDirtyModules(module2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDirtyModules(@NotNull Module module2) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCompilationPhase) {
                this.myChangedModulesDuringCompilation.add(module2);
            } else {
                this.myVFSChangedModules.add(module2);
            }
        }
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile file) {
        FileType fileType = this.myFileTypeRegistry.getFileTypeByFileName(file.getNameSequence());
        if (this.myService.getFileTypes().contains(fileType) && this.myService.getFileIndex().isInSourceContent(file)) {
            return this.myService.getFileIndex().getModuleForFile(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Set<Module> getAllDirtyModulesForTest() {
        Object object = this.myLock;
        synchronized (object) {
            return this.getAllDirtyModules();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    DirtyScopeTestInfo getState() {
        Object object = this.myLock;
        synchronized (object) {
            Object[] vfsChangedModules = this.myVFSChangedModules.toArray(Module.EMPTY_ARRAY);
            ArrayList<Module> unsavedChangedModuleList = new ArrayList<Module>(this.getAllDirtyModules());
            ContainerUtil.removeAll(unsavedChangedModuleList, (Object[])vfsChangedModules);
            Module[] unsavedChangedModules = unsavedChangedModuleList.toArray(Module.EMPTY_ARRAY);
            ArrayList excludedFiles = this.myExcludedFilesScope instanceof Iterable ? ContainerUtil.newArrayList((Iterable)((Iterable)this.myExcludedFilesScope)) : Collections.emptyList();
            return new DirtyScopeTestInfo((Module[])vfsChangedModules, unsavedChangedModules, excludedFiles.toArray(VirtualFile.EMPTY_ARRAY), this.getDirtyScope());
        }
    }
}

