/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.JavaCompilerElementRetriever;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

public class JavaCompilerRefAdapter
implements LanguageCompilerRefAdapter {
    @Override
    @NotNull
    public Set<FileType> getFileTypes() {
        return ContainerUtil.set((Object[])new FileType[]{JavaFileType.INSTANCE, JavaClassFileType.INSTANCE});
    }

    @Override
    public CompilerRef asCompilerRef(@NotNull PsiElement element, @NotNull NameEnumerator names) throws IOException {
        if (JavaCompilerRefAdapter.mayBeVisibleOutsideOwnerFile(element)) {
            int nameId;
            String jvmClassName;
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || aClass instanceof PsiAnonymousClass) {
                    return null;
                }
                String jvmOwnerName = ClassUtil.getJVMClassName((PsiClass)aClass);
                String name2 = field.getName();
                if (name2 == null || jvmOwnerName == null) {
                    return null;
                }
                int ownerId = names.tryEnumerate((Object)jvmOwnerName);
                if (ownerId == 0) {
                    return null;
                }
                int nameId2 = names.tryEnumerate((Object)name2);
                if (nameId2 == 0) {
                    return null;
                }
                return new CompilerRef.JavaCompilerFieldRef(ownerId, nameId2);
            }
            if (element instanceof PsiMethod) {
                PsiClass aClass = ((PsiMethod)element).getContainingClass();
                if (aClass == null || aClass instanceof PsiAnonymousClass) {
                    return null;
                }
                String jvmOwnerName = ClassUtil.getJVMClassName((PsiClass)aClass);
                if (jvmOwnerName == null) {
                    return null;
                }
                PsiMethod method = (PsiMethod)element;
                String name3 = method.isConstructor() ? "<init>" : method.getName();
                int parametersCount = method.getParameterList().getParametersCount();
                int ownerId = names.tryEnumerate((Object)jvmOwnerName);
                if (ownerId == 0) {
                    return null;
                }
                int nameId3 = names.tryEnumerate((Object)name3);
                if (nameId3 == 0) {
                    return null;
                }
                return new CompilerRef.JavaCompilerMethodRef(ownerId, nameId3, parametersCount);
            }
            if (element instanceof PsiClass && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null && (nameId = names.tryEnumerate((Object)jvmClassName)) != 0) {
                return new CompilerRef.JavaCompilerClassRef(nameId);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<CompilerRef> getHierarchyRestrictedToLibraryScope(@NotNull CompilerRef baseRef, @NotNull PsiElement basePsi, @NotNull NameEnumerator names, @NotNull GlobalSearchScope libraryScope) throws IOException {
        PsiClass baseClass = (PsiClass)ObjectUtils.notNull((Object)(basePsi instanceof PsiClass ? (PsiClass)basePsi : ((PsiMember)ReadAction.compute(() -> (PsiMember)basePsi)).getContainingClass()));
        ArrayList<CompilerRef> overridden = new ArrayList<CompilerRef>();
        IOException[] exception = new IOException[]{null};
        Processor processor2 = c -> {
            if (c.hasModifierProperty("private")) {
                return true;
            }
            String qName = (String)ReadAction.compute(() -> c.getQualifiedName());
            if (qName == null) {
                return true;
            }
            try {
                int nameId = names.tryEnumerate((Object)qName);
                if (nameId != 0) {
                    overridden.add(baseRef.override(nameId));
                }
            }
            catch (IOException e) {
                exception[0] = e;
                return false;
            }
            return true;
        };
        ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)LibraryScopeCache.getInstance((Project)baseClass.getProject()).getLibrariesOnlyScope(), (boolean)true).forEach(processor2);
        if (exception[0] != null) {
            throw exception[0];
        }
        return overridden;
    }

    @Override
    @NotNull
    public Class<? extends CompilerRef.CompilerClassHierarchyElementDef> getHierarchyObjectClass() {
        return CompilerRef.CompilerClassHierarchyElementDef.class;
    }

    @Override
    @NotNull
    public Class<? extends CompilerRef> getFunExprClass() {
        return CompilerRef.JavaCompilerFunExprDef.class;
    }

    @NotNull
    public PsiClass[] findDirectInheritorCandidatesInFile(@NotNull SearchId[] internalNames, @NotNull PsiFileWithStubSupport file) {
        return JavaCompilerElementRetriever.retrieveClassesByInternalIds(internalNames, file);
    }

    @NotNull
    public PsiFunctionalExpression[] findFunExpressionsInFile(@NotNull SearchId[] funExpressions, @NotNull PsiFileWithStubSupport file) {
        TIntHashSet requiredIndices = new TIntHashSet(funExpressions.length);
        for (SearchId funExpr : funExpressions) {
            requiredIndices.add(funExpr.getId());
        }
        return JavaCompilerElementRetriever.retrieveFunExpressionsByIndices(requiredIndices, file);
    }

    @Override
    public boolean isClass(@NotNull PsiElement element) {
        return element instanceof PsiClass;
    }

    @Override
    @NotNull
    public PsiElement[] getInstantiableConstructors(@NotNull PsiElement aClass) {
        if (!(aClass instanceof PsiClass)) {
            throw new IllegalArgumentException("parameter should be an instance of PsiClass: " + aClass);
        }
        PsiClass theClass = (PsiClass)aClass;
        if (theClass.hasModifierProperty("abstract")) {
            return PsiElement.EMPTY_ARRAY;
        }
        return (PsiElement[])Stream.of(theClass.getConstructors()).filter(c -> !c.hasModifierProperty("private")).toArray(s -> (PsiElement[])PsiElement.ARRAY_FACTORY.create(s));
    }

    @Override
    public boolean isDirectInheritor(PsiElement candidate, PsiNamedElement baseClass) {
        return ((PsiClass)candidate).isInheritor((PsiClass)baseClass, false);
    }

    private static boolean mayBeVisibleOutsideOwnerFile(@NotNull PsiElement element) {
        if (!(element instanceof PsiModifierListOwner)) {
            return true;
        }
        return !((PsiModifierListOwner)element).hasModifierProperty("private");
    }
}

