/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerReferenceHierarchyTestInfo {
    @Nullable
    private final CompilerDirectHierarchyInfo myHierarchyInfo;
    @NotNull
    private final DirtyScopeTestInfo myDirtyScopeInfo;

    public CompilerReferenceHierarchyTestInfo(@Nullable CompilerDirectHierarchyInfo hierarchyInfo, @NotNull DirtyScopeTestInfo dirtyScopeTestInfo) {
        this.myHierarchyInfo = hierarchyInfo;
        this.myDirtyScopeInfo = dirtyScopeTestInfo;
    }

    @NotNull
    public Stream<PsiElement> getHierarchyChildren() {
        if (this.myHierarchyInfo == null) {
            throw new IllegalArgumentException();
        }
        return this.myHierarchyInfo.getHierarchyChildren();
    }

    @NotNull
    Module[] getDirtyModules() {
        return this.myDirtyScopeInfo.getDirtyModules();
    }

    @NotNull
    Module[] getDirtyUnsavedModules() {
        return this.myDirtyScopeInfo.getDirtyUnsavedModules();
    }

    @NotNull
    VirtualFile[] getExcludedFiles() {
        return this.myDirtyScopeInfo.getExcludedFiles();
    }

    boolean isEnabled() {
        return this.myHierarchyInfo != null;
    }

    DefaultMutableTreeNode asTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        if (this.isEnabled()) {
            DefaultMutableTreeNode knownOccurrences = new DefaultMutableTreeNode("Known hierarchy direct children");
            node.add(knownOccurrences);
            this.getHierarchyChildren().forEach(e -> knownOccurrences.add(new DefaultMutableTreeNode(e)));
            DefaultMutableTreeNode dirtyModules = new DefaultMutableTreeNode("Dirty modules");
            node.add(dirtyModules);
            for (Module module2 : this.getDirtyModules()) {
                dirtyModules.add(new DefaultMutableTreeNode(module2));
            }
            DefaultMutableTreeNode unsavedDirtyModules = new DefaultMutableTreeNode("Unsaved dirty modules");
            node.add(unsavedDirtyModules);
            for (Module module3 : this.getDirtyUnsavedModules()) {
                unsavedDirtyModules.add(new DefaultMutableTreeNode(module3));
            }
            DefaultMutableTreeNode excludedFiles = new DefaultMutableTreeNode("Current excluded files");
            node.add(excludedFiles);
            for (VirtualFile excludedFile : this.getExcludedFiles()) {
                excludedFiles.add(new DefaultMutableTreeNode(excludedFile));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Service is not available"));
        }
        return node;
    }
}

