/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.treeStructure.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalCompilerRefServiceView
extends JPanel
implements DataProvider {
    private static final String TOOL_WINDOW_ID = "Compiler Reference View";
    private final Tree myTree;
    private final Project myProject;

    public InternalCompilerRefServiceView(Project project2) {
        this.myProject = project2;
        this.myTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof String) {
                    this.append((String)userObject, SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else if (userObject instanceof VirtualFile) {
                    this.append(((VirtualFile)userObject).getName());
                    this.append(" in ");
                    this.append(((VirtualFile)userObject).getParent().getPath(), SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else if (userObject instanceof PsiFunctionalExpression) {
                    this.append(ClassPresentationUtil.getFunctionalExpressionPresentation((PsiFunctionalExpression)((PsiFunctionalExpression)userObject), (boolean)true));
                } else if (userObject instanceof PsiClass) {
                    this.append(ClassPresentationUtil.getNameForClass((PsiClass)((PsiClass)userObject), (boolean)true));
                } else {
                    this.append(userObject.toString());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new JBScrollPane((Component)this.myTree));
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        TreePath path;
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && (path = this.myTree.getSelectionPath()) != null) {
            Object usrObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (usrObject instanceof VirtualFile) {
                return new OpenFileDescriptor(this.myProject, (VirtualFile)usrObject);
            }
            if (usrObject instanceof NavigatablePsiElement) {
                return usrObject;
            }
        }
        return null;
    }

    public static void showFindUsages(CompilerReferenceFindUsagesTestInfo info, PsiElement element) {
        InternalCompilerRefServiceView view = InternalCompilerRefServiceView.createViewTab(element);
        DefaultMutableTreeNode node = info.asTree();
        node.setUserObject(element);
        ((DefaultTreeModel)view.myTree.getModel()).setRoot(node);
    }

    public static void showHierarchyInfo(CompilerReferenceHierarchyTestInfo info, PsiElement element) {
        InternalCompilerRefServiceView view = InternalCompilerRefServiceView.createViewTab(element);
        DefaultMutableTreeNode node = info.asTree();
        node.setUserObject(element);
        ((DefaultTreeModel)view.myTree.getModel()).setRoot(node);
    }

    private static InternalCompilerRefServiceView createViewTab(PsiElement element) {
        Project project2 = element.getProject();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            toolWindow = toolWindowManager.registerToolWindow(TOOL_WINDOW_ID, true, ToolWindowAnchor.TOP);
        }
        InternalCompilerRefServiceView view = new InternalCompilerRefServiceView(project2);
        ToolWindow finalToolWindow = toolWindow;
        toolWindow.activate(() -> {
            String text = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)element);
            ContentImpl content = new ContentImpl((JComponent)view, text, true);
            finalToolWindow.getContentManager().addContent((Content)content);
            finalToolWindow.getContentManager().setSelectedContent((Content)content, true);
        });
        return view;
    }
}

