/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;

public interface ChainOperation {

    public static class MethodCall
    implements ChainOperation {
        @NotNull
        private final PsiMethod[] myCandidates;

        public MethodCall(@NotNull PsiMethod[] candidates) {
            if (candidates.length == 0) {
                throw new IllegalStateException();
            }
            this.myCandidates = candidates;
        }

        @NotNull
        public PsiMethod[] getCandidates() {
            return this.myCandidates;
        }

        public String toString() {
            return this.myCandidates[0].getName() + "()";
        }
    }

    public static class TypeCast
    implements ChainOperation {
        private final PsiClass myOperandClass;
        @NotNull
        private final PsiClass myCastClass;

        public TypeCast(@NotNull PsiClass operandClass, @NotNull PsiClass castClass) {
            this.myOperandClass = operandClass;
            this.myCastClass = castClass;
        }

        @NotNull
        public PsiClass getCastClass() {
            return this.myCastClass;
        }

        public String toString() {
            return "cast of " + this.myOperandClass.getName();
        }
    }
}

