/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.compiler.chainsSearch.ChainOperation;
import com.intellij.compiler.chainsSearch.ChainRelevance;
import com.intellij.compiler.chainsSearch.MethodChainsSearchUtil;
import com.intellij.compiler.chainsSearch.OperationChain;
import com.intellij.compiler.chainsSearch.completion.lookup.ChainCompletionNewVariableLookupElement;
import com.intellij.compiler.chainsSearch.completion.lookup.JavaRelevantChainLookupElement;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MethodChainLookupRangingHelper {
    @NotNull
    public static LookupElement toLookupElement(OperationChain chain, ChainCompletionContext context) {
        int unreachableParametersCount = 0;
        int matchedParametersInContext = 0;
        LookupElement chainLookupElement = null;
        for (ChainOperation op : chain.getPath()) {
            if (op instanceof ChainOperation.MethodCall) {
                PsiMethod method = (PsiMethod)ObjectUtils.notNull((Object)MethodChainsSearchUtil.getMethodWithMinNotPrimitiveParameters(((ChainOperation.MethodCall)op).getCandidates(), context.getTarget().getTargetClass()));
                Couple<Integer> info = MethodChainLookupRangingHelper.calculateParameterInfo(method, context);
                unreachableParametersCount += ((Integer)info.getFirst()).intValue();
                matchedParametersInContext += ((Integer)info.getSecond()).intValue();
                if (chainLookupElement == null) {
                    LookupElement qualifierLookupElement = method.hasModifierProperty("static") ? null : MethodChainLookupRangingHelper.createQualifierLookupElement(chain.getQualifierClass(), context);
                    LookupElement headLookupElement = MethodChainLookupRangingHelper.createMethodLookupElement(method);
                    chainLookupElement = qualifierLookupElement == null ? headLookupElement : new JavaChainLookupElement(qualifierLookupElement, headLookupElement);
                    continue;
                }
                chainLookupElement = new JavaChainLookupElement(chainLookupElement, (LookupElement)new JavaMethodCallElement(method));
                continue;
            }
            if (chainLookupElement == null) {
                chainLookupElement = MethodChainLookupRangingHelper.createQualifierLookupElement(chain.getQualifierClass(), context);
            }
            PsiClass castClass = ((ChainOperation.TypeCast)op).getCastClass();
            PsiClassType type = JavaPsiFacade.getElementFactory((Project)castClass.getProject()).createType(castClass);
            chainLookupElement = PrioritizedLookupElement.withPriority((LookupElement)CastingLookupElementDecorator.createCastingElement((LookupElement)chainLookupElement, (PsiType)type), (double)-1.0);
        }
        if (context.getTarget().isIteratorAccess()) {
            chainLookupElement = MethodChainLookupRangingHelper.decorateWithIteratorAccess(chain.getFirst()[0], chainLookupElement);
        }
        return new JavaRelevantChainLookupElement((LookupElement)ObjectUtils.notNull(chainLookupElement), new ChainRelevance(chain.length(), unreachableParametersCount, matchedParametersInContext));
    }

    @NotNull
    private static LookupElementDecorator<LookupElement> decorateWithIteratorAccess(final PsiMethod method, LookupElement chainLookupElement) {
        return new LookupElementDecorator<LookupElement>(chainLookupElement){

            public void handleInsert(@NotNull InsertionContext context) {
                super.handleInsert(context);
                Document document2 = context.getDocument();
                int tail = context.getTailOffset();
                PsiType tailReturnType = method.getReturnType();
                if (tailReturnType instanceof PsiArrayType) {
                    document2.insertString(tail, (CharSequence)"[0]");
                    context.getEditor().getCaretModel().moveToOffset(tail + 1);
                } else {
                    PsiClass returnClass = (PsiClass)ObjectUtils.notNull((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)tailReturnType));
                    PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document2);
                    if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.List")) {
                        document2.insertString(tail, (CharSequence)".get(0)");
                        context.getEditor().getCaretModel().moveToOffset(tail + 5);
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Collection")) {
                        document2.insertString(tail, (CharSequence)".iterator().next()");
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Iterator")) {
                        document2.insertString(tail, (CharSequence)".next()");
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.stream.Stream")) {
                        document2.insertString(tail, (CharSequence)".findFirst().get()");
                    }
                }
            }
        };
    }

    @NotNull
    private static LookupElement createQualifierLookupElement(@NotNull PsiClass qualifierClass, @NotNull ChainCompletionContext context) {
        PsiNamedElement element = context.getQualifiers(qualifierClass).findFirst().orElse(null);
        if (element == null) {
            return new ChainCompletionNewVariableLookupElement(qualifierClass, context);
        }
        if (element instanceof PsiVariable) {
            return new VariableLookupItem((PsiVariable)element);
        }
        if (element instanceof PsiMethod) {
            return MethodChainLookupRangingHelper.createMethodLookupElement((PsiMethod)element);
        }
        throw new AssertionError((Object)("unexpected element: " + element));
    }

    @NotNull
    private static Couple<Integer> calculateParameterInfo(@NotNull PsiMethod method, @NotNull ChainCompletionContext context) {
        int unreachableParametersCount = 0;
        int matchedParametersInContext = 0;
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            PsiType type = parameter.getType();
            if (ChainCompletionContext.isWidelyUsed(type)) continue;
            Collection contextVariables = context.getQualifiers(type).collect(Collectors.toList());
            PsiElement contextVariable = (PsiElement)ContainerUtil.getFirstItem((Collection)contextVariables, null);
            if (contextVariable != null) {
                ++matchedParametersInContext;
                continue;
            }
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)parameter)) continue;
            ++unreachableParametersCount;
        }
        return Couple.of((Object)unreachableParametersCount, (Object)matchedParametersInContext);
    }

    @NotNull
    private static LookupElement createMethodLookupElement(@NotNull PsiMethod method) {
        JavaMethodCallElement result;
        if (method.isConstructor()) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            result = new ExpressionLookupItem(elementFactory.createExpressionFromText("new " + method.getContainingClass().getQualifiedName() + "()", null));
        } else {
            result = method.hasModifierProperty("static") ? new JavaMethodCallElement(method, false, true) : new JavaMethodCallElement(method);
        }
        return result;
    }
}

