/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodChainsSearchUtil {
    private MethodChainsSearchUtil() {
    }

    @Nullable
    public static PsiMethod getMethodWithMinNotPrimitiveParameters(@NotNull PsiMethod[] methods, @NotNull PsiClass target) {
        return Stream.of(methods).filter(m -> {
            for (PsiParameter parameter : m.getParameterList().getParameters()) {
                PsiType t = parameter.getType();
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)t);
                if (aClass != target) continue;
                return false;
            }
            return true;
        }).min(Comparator.comparing(MethodChainsSearchUtil::getNonPrimitiveParameterCount)).orElse(null);
    }

    private static int getNonPrimitiveParameterCount(PsiMethod method) {
        return (int)Stream.of(method.getParameterList().getParameters()).map(p -> p.getType()).filter(t -> !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)t)).count();
    }
}

