/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.context;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;

public class ChainCompletionContext {
    private static final String[] WIDELY_USED_CLASS_NAMES = new String[]{"java.lang.String", "java.lang.Object", "java.lang.Class"};
    private static final Set<String> WIDELY_USED_SHORT_NAMES = ContainerUtil.set((Object[])new String[]{"String", "Object", "Class"});
    @NotNull
    private final ChainSearchTarget myTarget;
    @NotNull
    private final List<PsiNamedElement> myContextElements;
    @NotNull
    private final PsiElement myContext;
    @NotNull
    private final GlobalSearchScope myResolveScope;
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiResolveHelper myResolveHelper;
    @NotNull
    private final TIntObjectHashMap<PsiClass> myQualifierClassResolver;
    @NotNull
    private final Map<MethodCall, PsiMethod[]> myResolver;
    @NotNull
    private final CompilerReferenceServiceEx myRefServiceEx;
    private final NotNullLazyValue<Set<CompilerRef>> myContextClassReferences = new NotNullLazyValue<Set<CompilerRef>>(){

        @NotNull
        protected Set<CompilerRef> compute() {
            return ChainCompletionContext.this.getContextTypes().stream().map(PsiUtil::resolveClassInType).filter(Objects::nonNull).map(c -> ClassUtil.getJVMClassName((PsiClass)c)).filter(Objects::nonNull).mapToInt(c -> ChainCompletionContext.this.myRefServiceEx.getNameId((String)c)).filter(n -> n != 0).mapToObj(n -> new CompilerRef.JavaCompilerClassRef(n)).collect(Collectors.toSet());
        }
    };

    public ChainCompletionContext(@NotNull ChainSearchTarget target, @NotNull List<PsiNamedElement> contextElements, @NotNull PsiElement context) {
        this.myTarget = target;
        this.myContextElements = contextElements;
        this.myContext = context;
        this.myResolveScope = context.getResolveScope();
        this.myProject = context.getProject();
        this.myResolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)this.myProject);
        this.myQualifierClassResolver = new TIntObjectHashMap();
        this.myResolver = FactoryMap.create(sign -> sign.resolve());
        this.myRefServiceEx = (CompilerReferenceServiceEx)CompilerReferenceService.getInstance((Project)this.myProject);
    }

    @NotNull
    public ChainSearchTarget getTarget() {
        return this.myTarget;
    }

    public boolean contains(@Nullable PsiType type) {
        if (type == null) {
            return false;
        }
        Set<PsiType> types = this.getContextTypes();
        if (types.contains(type)) {
            return true;
        }
        for (PsiType contextType : types) {
            if (!type.isAssignableFrom(contextType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public CompilerReferenceServiceEx getRefService() {
        return this.myRefServiceEx;
    }

    @NotNull
    public PsiElement getContextPsi() {
        return this.myContext;
    }

    public PsiFile getContextFile() {
        return this.myContext.getContainingFile();
    }

    @NotNull
    public Set<PsiType> getContextTypes() {
        return this.myContextElements.stream().map(ChainCompletionContext::getType).collect(Collectors.toSet());
    }

    @NotNull
    public Set<CompilerRef> getContextClassReferences() {
        return (Set)this.myContextClassReferences.getValue();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myResolveScope;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public boolean hasQualifier(@Nullable PsiClass targetClass) {
        return this.getQualifiers(targetClass).findAny().isPresent();
    }

    public Stream<PsiNamedElement> getQualifiers(@Nullable PsiClass targetClass) {
        if (targetClass == null) {
            return Stream.empty();
        }
        return this.getQualifiers((PsiType)JavaPsiFacade.getElementFactory((Project)this.myProject).createType(targetClass));
    }

    public Stream<PsiNamedElement> getQualifiers(@NotNull PsiType targetType) {
        return this.myContextElements.stream().filter(e -> {
            PsiType elementType = ChainCompletionContext.getType((PsiElement)e);
            return elementType != null && targetType.isAssignableFrom(elementType);
        });
    }

    @Nullable
    public PsiClass resolvePsiClass(CompilerRef.CompilerClassHierarchyElementDef aClass) {
        int nameId = aClass.getName();
        if (this.myQualifierClassResolver.contains(nameId)) {
            return (PsiClass)this.myQualifierClassResolver.get(nameId);
        }
        PsiClass psiClass = null;
        String name2 = this.myRefServiceEx.getName(nameId);
        PsiClass resolvedClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(name2, this.myResolveScope);
        if (resolvedClass != null && this.accessValidator().test((PsiMember)resolvedClass)) {
            psiClass = resolvedClass;
        }
        this.myQualifierClassResolver.put(nameId, psiClass);
        return psiClass;
    }

    @NotNull
    public PsiMethod[] resolve(MethodCall sign) {
        return this.myResolver.get(sign);
    }

    public Predicate<PsiMember> accessValidator() {
        return m -> this.myResolveHelper.isAccessible(m, this.myContext, null);
    }

    @Nullable
    public static ChainCompletionContext createContext(@Nullable PsiType targetType, @Nullable PsiElement containingElement, boolean suggestIterators) {
        if (containingElement == null) {
            return null;
        }
        ChainSearchTarget target = ChainSearchTarget.create(targetType);
        if (target == null) {
            return null;
        }
        if (suggestIterators) {
            target = target.toIterators();
        }
        Set<? extends PsiVariable> excludedVariables = ChainCompletionContext.getEnclosingLocalVariables(containingElement);
        ContextProcessor processor2 = new ContextProcessor(null, containingElement.getProject(), containingElement, excludedVariables);
        PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor2, (PsiElement)containingElement, (PsiElement)containingElement.getContainingFile());
        List<PsiNamedElement> contextElements = processor2.getContextElements();
        return new ChainCompletionContext(target, contextElements, containingElement);
    }

    @NotNull
    private static Set<? extends PsiVariable> getEnclosingLocalVariables(@NotNull PsiElement place) {
        THashSet result = new THashSet();
        if (place instanceof PsiLocalVariable) {
            result.add((PsiLocalVariable)place);
        }
        for (PsiElement parent = place.getParent(); parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            if (!(parent instanceof PsiLocalVariable) || !PsiTreeUtil.isAncestor((PsiElement)((PsiLocalVariable)parent).getInitializer(), (PsiElement)place, (boolean)false)) continue;
            result.add((PsiLocalVariable)parent);
        }
        return result;
    }

    @Nullable
    private static PsiType getType(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    public static boolean isWidelyUsed(@NotNull PsiType type) {
        if ((type = type.getDeepComponentType()) instanceof PsiPrimitiveType) {
            return true;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        if (WIDELY_USED_SHORT_NAMES.contains(((PsiClassType)type).getClassName())) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type).resolve();
        if (resolvedClass == null) {
            return false;
        }
        String qName = resolvedClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        for (String name2 : WIDELY_USED_CLASS_NAMES) {
            if (!name2.equals(qName)) continue;
            return true;
        }
        return false;
    }

    private static class ContextProcessor
    implements PsiScopeProcessor,
    ElementClassHint {
        private final List<PsiNamedElement> myContextElements = new SmartList();
        private final PsiVariable myCompletionVariable;
        private final PsiResolveHelper myResolveHelper;
        private final PsiElement myPlace;
        private final Set<? extends PsiVariable> myExcludedVariables;

        private ContextProcessor(@Nullable PsiVariable variable, @NotNull Project project2, @NotNull PsiElement place, @NotNull Set<? extends PsiVariable> excludedVariables) {
            this.myCompletionVariable = variable;
            this.myResolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)project2);
            this.myPlace = place;
            this.myExcludedVariables = excludedVariables;
        }

        public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
            return kind == ElementClassHint.DeclarationKind.ENUM_CONST || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.METHOD || kind == ElementClassHint.DeclarationKind.VARIABLE;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (!(element instanceof PsiMethod && !PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)element)) || element instanceof PsiVariable && this.myExcludedVariables.contains(element) || element instanceof PsiMember && !this.myResolveHelper.isAccessible((PsiMember)element, this.myPlace, null))) {
                PsiType type = ChainCompletionContext.getType(element);
                if (type == null) {
                    return true;
                }
                if (ChainCompletionContext.isWidelyUsed(type)) {
                    return true;
                }
                this.myContextElements.add((PsiNamedElement)element);
            }
            return true;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == ElementClassHint.KEY) {
                return (T)this;
            }
            return null;
        }

        @NotNull
        public List<PsiNamedElement> getContextElements() {
            this.myContextElements.remove(this.myCompletionVariable);
            return this.myContextElements;
        }
    }
}

