/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompilerCacheManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerCacheManager");
    private final Map<Compiler, Object> myCompilerToCacheMap = new HashMap<Compiler, Object>();
    private final List<Disposable> myCacheDisposables = new ArrayList<Disposable>();
    private final File myCachesRoot;

    public CompilerCacheManager(Project project2) {
        this.myCachesRoot = CompilerPaths.getCacheStoreDirectory((Project)project2);
    }

    public static CompilerCacheManager getInstance(Project project2) {
        return (CompilerCacheManager)project2.getComponent(CompilerCacheManager.class);
    }

    public void dispose() {
        this.flushCaches();
    }

    private File getCompilerRootDir(Compiler compiler) {
        File dir = new File(this.myCachesRoot, CompilerCacheManager.getCompilerIdString(compiler));
        dir.mkdirs();
        return dir;
    }

    synchronized FileProcessingCompilerStateCache getFileProcessingCompilerCache(FileProcessingCompiler compiler) throws IOException {
        Object cache = this.myCompilerToCacheMap.get(compiler);
        if (cache == null) {
            File compilerRootDir = this.getCompilerRootDir((Compiler)compiler);
            FileProcessingCompilerStateCache stateCache = new FileProcessingCompilerStateCache(compilerRootDir, (ValidityStateFactory)compiler);
            this.myCompilerToCacheMap.put((Compiler)compiler, stateCache);
            this.myCacheDisposables.add(() -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing cache for compiler " + compiler.getDescription() + "; cache root dir: " + compilerRootDir);
                }
                stateCache.close();
            });
            cache = stateCache;
        } else {
            LOG.assertTrue(cache instanceof FileProcessingCompilerStateCache);
        }
        return (FileProcessingCompilerStateCache)cache;
    }

    public static String getCompilerIdString(Compiler compiler) {
        String description = compiler.getDescription();
        return description.replaceAll("\\s+", "_").replaceAll("[\\.\\?]", "_").toLowerCase();
    }

    synchronized void flushCaches() {
        for (Disposable disposable : this.myCacheDisposables) {
            try {
                Disposer.dispose((Disposable)disposable);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        this.myCacheDisposables.clear();
        this.myCompilerToCacheMap.clear();
    }

    public void clearCaches(CompileContext context) {
        this.flushCaches();
        File[] children = this.myCachesRoot.listFiles();
        if (children != null) {
            for (File child : children) {
                boolean deleteOk = FileUtil.delete((File)child);
                if (deleteOk) continue;
                context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.failed.to.delete", (Object[])new Object[]{child.getPath()}), null, -1, -1);
            }
        }
    }
}

