/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final List<CompileScope> myScopes = new ArrayList<CompileScope>();

    public CompositeScope(@NotNull CompileScope scope1, @NotNull CompileScope scope2) {
        this.addScope(scope1);
        this.addScope(scope2);
    }

    public CompositeScope(@NotNull CompileScope[] scopes) {
        for (CompileScope scope : scopes) {
            this.addScope(scope);
        }
    }

    private void addScope(@NotNull CompileScope scope) {
        if (scope instanceof CompositeScope) {
            CompositeScope compositeScope = (CompositeScope)scope;
            for (CompileScope childScope : compositeScope.myScopes) {
                this.addScope(childScope);
            }
        } else {
            this.myScopes.add(scope);
        }
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        THashSet allFiles = new THashSet();
        for (CompileScope scope : this.myScopes) {
            Object[] files = scope.getFiles(fileType, inSourceOnly);
            if (files.length <= 0) continue;
            ContainerUtil.addAll((Collection)allFiles, (Object[])files);
        }
        return VfsUtilCore.toVirtualFileArray((Collection)allFiles);
    }

    public boolean belongs(@NotNull String url) {
        for (CompileScope scope : this.myScopes) {
            if (!scope.belongs(url)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Module[] getAffectedModules() {
        HashSet modules = new HashSet();
        for (CompileScope compileScope : this.myScopes) {
            ContainerUtil.addAll(modules, (Object[])compileScope.getAffectedModules());
        }
        return modules.toArray(Module.EMPTY_ARRAY);
    }

    @NotNull
    public Collection<String> getAffectedUnloadedModules() {
        LinkedHashSet<String> unloadedModules = new LinkedHashSet<String>();
        for (CompileScope compileScope : this.myScopes) {
            ContainerUtil.addAll(unloadedModules, (Iterable)compileScope.getAffectedUnloadedModules());
        }
        return unloadedModules;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        for (CompileScope compileScope : this.myScopes) {
            Object userData = compileScope.getUserData(key);
            if (userData == null) continue;
            return (T)userData;
        }
        return (T)super.getUserData(key);
    }

    @NotNull
    public Collection<CompileScope> getScopes() {
        return Collections.unmodifiableList(this.myScopes);
    }
}

