/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSetCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final Set<VirtualFile> myRootFiles = new HashSet<VirtualFile>();
    private final Set<String> myDirectoryUrls = new HashSet<String>();
    private Set<String> myUrls;
    private final Module[] myAffectedModules;

    public FileSetCompileScope(@NotNull Collection<VirtualFile> files, @NotNull Module[] modules) {
        this.myAffectedModules = modules;
        ApplicationManager.getApplication().runReadAction(() -> {
            for (VirtualFile file : files) {
                assert (file != null);
                this.addFile(file);
            }
        });
    }

    @NotNull
    public Module[] getAffectedModules() {
        return this.myAffectedModules;
    }

    @NotNull
    public Collection<VirtualFile> getRootFiles() {
        return Collections.unmodifiableCollection(this.myRootFiles);
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        Iterator<VirtualFile> it = this.myRootFiles.iterator();
        while (it.hasNext()) {
            VirtualFile file = it.next();
            if (!file.isValid()) {
                it.remove();
                continue;
            }
            if (file.isDirectory()) {
                FileSetCompileScope.addRecursively(files, file, fileType);
                continue;
            }
            if (fileType != null && !fileType.equals(file.getFileType())) continue;
            files.add(file);
        }
        return VfsUtilCore.toVirtualFileArray(files);
    }

    public boolean belongs(@NotNull String url) {
        if (this.getUrls().contains(url)) {
            return true;
        }
        for (String directoryUrl : this.myDirectoryUrls) {
            if (!FileUtil.startsWith((String)url, (String)directoryUrl)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<String> getUrls() {
        if (this.myUrls == null) {
            this.myUrls = new HashSet<String>();
            for (VirtualFile file : this.myRootFiles) {
                String url = file.getUrl();
                this.myUrls.add(url);
            }
        }
        return this.myUrls;
    }

    private void addFile(@NotNull VirtualFile file) {
        if (file.isDirectory()) {
            this.myDirectoryUrls.add(file.getUrl() + "/");
        }
        this.myRootFiles.add(file);
        this.myUrls = null;
    }

    private static void addRecursively(final @NotNull Collection<? super VirtualFile> container, @NotNull VirtualFile fromDirectory, final @Nullable FileType fileType) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromDirectory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

            public boolean visitFile(@NotNull VirtualFile child) {
                if (!child.isDirectory() && (fileType == null || fileType.equals(child.getFileType()))) {
                    container.add(child);
                }
                return true;
            }
        });
    }
}

