/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.util.TripleFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesContainer {
    private static final Logger LOG = Logger.getInstance(MessagesContainer.class);
    private static final int JAVAC_TAB_SIZE = 8;
    private final Project myProject;
    private final Map<CompilerMessageCategory, Collection<CompilerMessage>> myMessages = new EnumMap<CompilerMessageCategory, Collection<CompilerMessage>>(CompilerMessageCategory.class);
    private final int myTabSize;

    public MessagesContainer(@NotNull Project project2) {
        this.myProject = project2;
        this.myTabSize = MessagesContainer.getTabSize(project2);
    }

    private static int getTabSize(@NotNull Project project2) {
        try {
            return CodeStyle.getSettings((Project)project2).getTabSize((FileType)StdFileTypes.JAVA);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Cannot compute tab size", (Throwable)e);
            return 4;
        }
    }

    @NotNull
    public Collection<CompilerMessage> getMessages(@NotNull CompilerMessageCategory category) {
        Collection<CompilerMessage> collection = this.myMessages.get(category);
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    @Nullable
    public CompilerMessage addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum, Navigatable navigatable) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message, MessagesContainer.findFileByUrl(url), lineNum, columnNum, navigatable);
        if (this.addMessage(msg)) {
            msg.setColumnAdjuster((TripleFunction<? super CompilerMessage, ? super Integer, ? super Integer, Integer>)((TripleFunction)(m, line, col) -> this.adjustColumn((CompilerMessage)m, (int)line, (int)col)));
            return msg;
        }
        return null;
    }

    private int adjustColumn(CompilerMessage m, int line, int col) {
        int tabCount;
        VirtualFile file;
        if (this.myTabSize != 8 && line >= 1 && (file = m.getVirtualFile()) != null && file.isValid() && (tabCount = ((Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document doc = FileDocumentManager.getInstance().getDocument(file);
            if (doc == null) {
                return 0;
            }
            int tcount = 0;
            CharSequence seq = doc.getCharsSequence();
            int start = doc.getLineStartOffset(line);
            int end = doc.getLineEndOffset(line);
            int charsExpanded = 0;
            for (int i = start; i < end; ++i) {
                if (seq.charAt(i) == '\t') {
                    charsExpanded += 8;
                    ++tcount;
                } else {
                    ++charsExpanded;
                }
                if (charsExpanded >= col) break;
            }
            return tcount;
        })).intValue()) > 0) {
            return Math.max(0, col + tabCount * (this.myTabSize - 8));
        }
        return col;
    }

    public boolean addMessage(CompilerMessage msg) {
        Collection messages = this.myMessages.computeIfAbsent(msg.getCategory(), k -> new LinkedHashSet());
        return messages.add(msg);
    }

    @Nullable
    private static VirtualFile findFileByUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            return VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
        }
        return file;
    }

    public int getMessageCount(@Nullable CompilerMessageCategory category) {
        if (category != null) {
            Collection<CompilerMessage> collection = this.myMessages.get(category);
            return collection != null ? collection.size() : 0;
        }
        return this.myMessages.values().stream().filter(Objects::nonNull).mapToInt(Collection::size).sum();
    }
}

