/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompilerContentIterator;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OneProjectItemCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.OneProjectItemCompileScope");
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myUrl;

    public OneProjectItemCompileScope(Project project2, VirtualFile file) {
        this.myProject = project2;
        this.myFile = file;
        String url = file.getUrl();
        this.myUrl = file.isDirectory() ? url + "/" : url;
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        ArrayList files = new ArrayList(1);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerContentIterator iterator2 = new CompilerContentIterator(fileType, (FileIndex)projectFileIndex, inSourceOnly, files);
        if (this.myFile.isDirectory()) {
            projectFileIndex.iterateContentUnderDirectory(this.myFile, (ContentIterator)iterator2);
        } else {
            iterator2.processFile(this.myFile);
        }
        return VfsUtil.toVirtualFileArray(files);
    }

    public boolean belongs(@NotNull String url) {
        if (this.myFile.isDirectory()) {
            return FileUtil.startsWith((String)url, (String)this.myUrl);
        }
        return FileUtil.pathsEqual((String)url, (String)this.myUrl);
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module module2 = ModuleUtil.findModuleForFile((VirtualFile)this.myFile, (Project)this.myProject);
        if (module2 == null) {
            LOG.error("Module is null for file " + this.myFile.getPresentableUrl());
            return Module.EMPTY_ARRAY;
        }
        return new Module[]{module2};
    }
}

