/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChangeSuperClassFix
implements LocalQuickFix,
HighPriorityAction {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myNewSuperClass;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myOldSuperClass;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myTargetClass;
    private final int myInheritorCount;
    @NotNull
    private final String myNewSuperName;
    private final boolean myImplements;

    public ChangeSuperClassFix(@NotNull PsiClass targetClass, @NotNull PsiClass newSuperClass, @NotNull PsiClass oldSuperClass, int percent, boolean isImplements) {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)newSuperClass.getProject());
        this.myNewSuperName = (String)ObjectUtils.notNull((Object)newSuperClass.getQualifiedName());
        this.myTargetClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)targetClass);
        this.myNewSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)newSuperClass);
        this.myOldSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)oldSuperClass);
        this.myInheritorCount = percent;
        this.myImplements = isImplements;
    }

    @NotNull
    public PsiClass getNewSuperClass() {
        return (PsiClass)ObjectUtils.notNull((Object)this.myNewSuperClass.getElement());
    }

    public int getInheritorCount() {
        return this.myInheritorCount;
    }

    @NotNull
    public String getName() {
        return String.format("Make " + (this.myImplements ? "implements" : "extends") + " '%s'", this.myNewSuperName);
    }

    @NotNull
    public String getFamilyName() {
        return GroupNames.INHERITANCE_GROUP_NAME;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor problemDescriptor) {
        PsiClass oldSuperClass = (PsiClass)this.myOldSuperClass.getElement();
        PsiClass newSuperClass = (PsiClass)this.myNewSuperClass.getElement();
        if (oldSuperClass == null || newSuperClass == null) {
            return;
        }
        PsiClass aClass = (PsiClass)this.myTargetClass.getElement();
        if (aClass == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{aClass})) {
            return;
        }
        ChangeSuperClassFix.changeSuperClass(aClass, oldSuperClass, newSuperClass);
    }

    private static void changeSuperClass(@NotNull PsiClass aClass, @NotNull PsiClass oldSuperClass, @NotNull PsiClass newSuperClass) {
        PsiMethod[] ownMethods = aClass.getMethods();
        List oldOverridenMethods = Stream.of(ownMethods).map(m -> {
            if (m.isConstructor()) {
                return null;
            }
            Object[] supers = m.findSuperMethods(oldSuperClass);
            if (supers.length == 0) {
                return null;
            }
            return Pair.create((Object)m, (Object)ContainerUtil.set((Object[])supers));
        }).filter(Objects::nonNull).collect(Collectors.toList());
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)aClass.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        WriteAction.run(() -> {
            PsiElement ref;
            if (aClass instanceof PsiAnonymousClass) {
                ref = ((PsiAnonymousClass)aClass).getBaseClassReference().replace((PsiElement)factory.createClassReferenceElement(newSuperClass));
            } else {
                PsiReferenceList list;
                PsiJavaCodeReferenceElement[] refElements;
                PsiReferenceList extendsList = (PsiReferenceList)ObjectUtils.notNull((Object)aClass.getExtendsList());
                for (PsiJavaCodeReferenceElement refElement : refElements = (PsiJavaCodeReferenceElement[])ArrayUtil.mergeArrays((Object[])ChangeSuperClassFix.getReferences(extendsList), (Object[])ChangeSuperClassFix.getReferences(aClass.getImplementsList()))) {
                    if (!refElement.isReferenceTo((PsiElement)oldSuperClass)) continue;
                    refElement.delete();
                }
                if (newSuperClass.isInterface() && !aClass.isInterface()) {
                    list = aClass.getImplementsList();
                } else {
                    PsiClass objectClass;
                    list = extendsList;
                    PsiJavaCodeReferenceElement[] elements = list.getReferenceElements();
                    if (elements.length == 1 && (objectClass = psiFacade.findClass("java.lang.Object", aClass.getResolveScope())) != null && elements[0].isReferenceTo((PsiElement)objectClass)) {
                        elements[0].delete();
                    }
                }
                assert (list != null);
                ref = list.add((PsiElement)factory.createClassReferenceElement(newSuperClass));
            }
            JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(ref);
        });
        List<MemberInfo> memberInfos = oldOverridenMethods.stream().filter(m -> {
            Set newSupers = ContainerUtil.set((Object[])((PsiMethod)m.getFirst()).findSuperMethods(newSuperClass));
            return !newSupers.equals(m.getSecond());
        }).map(m -> (PsiMethod)m.getFirst()).map(m -> {
            MemberInfo info = new MemberInfo((PsiMember)m);
            info.setChecked(true);
            return info;
        }).collect(Collectors.toList());
        if (memberInfos.isEmpty()) {
            return;
        }
        List<PsiMethod> toDelete = ChangeSuperClassFix.getOverridenMethodsToDelete(memberInfos, newSuperClass.getName(), aClass.getProject());
        if (!toDelete.isEmpty()) {
            WriteAction.run(() -> {
                for (PsiMethod method : toDelete) {
                    method.delete();
                }
            });
        }
    }

    @NotNull
    private static PsiJavaCodeReferenceElement[] getReferences(PsiReferenceList list) {
        return list == null ? PsiJavaCodeReferenceElement.EMPTY_ARRAY : list.getReferenceElements();
    }

    @NotNull
    private static List<PsiMethod> getOverridenMethodsToDelete(List<MemberInfo> candidates, String newClassName, Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ContainerUtil.map(candidates, c -> (PsiMethod)c.getMember());
        }
        final MemberSelectionPanel panel = new MemberSelectionPanel("<html>Choose members to delete since they are already defined in <b>" + newClassName + "</b>", candidates, null);
        DialogWrapper dlg = new DialogWrapper(project2, false){
            {
                super(x0, x1);
                this.setOKButtonText("Remove");
                this.setTitle("Choose Members");
                this.init();
            }

            @NotNull
            protected JComponent createCenterPanel() {
                return panel;
            }
        };
        return dlg.showAndGet() ? ContainerUtil.map((Collection)panel.getTable().getSelectedMemberInfos(), info -> (PsiMethod)info.getMember()) : Collections.emptyList();
    }
}

