/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.EmptyCompileScopeBuildTaskImpl;
import com.intellij.util.concurrency.Semaphore;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileStepBeforeRun
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.options.CompileStepBeforeRun");
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Make");
    @Deprecated
    public static final Key<RunConfiguration> RUN_CONFIGURATION = CompilerManager.RUN_CONFIGURATION_KEY;
    @Deprecated
    public static final Key<String> RUN_CONFIGURATION_TYPE_ID = CompilerManager.RUN_CONFIGURATION_TYPE_ID_KEY;
    @NonNls
    protected static final String MAKE_PROJECT_ON_RUN_KEY = "makeProjectOnRun";
    private final Project myProject;

    public CompileStepBeforeRun(@NotNull Project project2) {
        this.myProject = project2;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public String getDescription(MakeBeforeRunTask task) {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Actions.Compile;
    }

    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AllIcons.Actions.Compile;
    }

    @Nullable
    public MakeBeforeRunTask createTask(@NotNull RunConfiguration configuration) {
        MakeBeforeRunTask task = null;
        if (CompileStepBeforeRun.shouldCreateTask(configuration)) {
            task = new MakeBeforeRunTask();
            task.setEnabled(CompileStepBeforeRun.isEnabledByDefault(configuration));
        }
        return task;
    }

    private static boolean isEnabledByDefault(@NotNull RunConfiguration configuration) {
        if (configuration instanceof RunProfileWithCompileBeforeLaunchOption) {
            return ((RunProfileWithCompileBeforeLaunchOption)configuration).isBuildBeforeLaunchAddedByDefault();
        }
        return false;
    }

    static boolean shouldCreateTask(RunConfiguration configuration) {
        return !(configuration instanceof RemoteConfiguration) && configuration instanceof RunProfileWithCompileBeforeLaunchOption;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull MakeBeforeRunTask task) {
        return CompileStepBeforeRun.doMake(this.myProject, configuration, env, false);
    }

    static boolean doMake(Project myProject, RunConfiguration configuration, ExecutionEnvironment env, boolean ignoreErrors) {
        return CompileStepBeforeRun.doMake(myProject, configuration, env, ignoreErrors, Boolean.getBoolean(MAKE_PROJECT_ON_RUN_KEY));
    }

    static boolean doMake(Project myProject, RunConfiguration configuration, ExecutionEnvironment env, boolean ignoreErrors, boolean forceMakeProject) {
        if (!(configuration instanceof RunProfileWithCompileBeforeLaunchOption)) {
            return true;
        }
        RunProfileWithCompileBeforeLaunchOption runConfiguration = (RunProfileWithCompileBeforeLaunchOption)configuration;
        if (runConfiguration.isExcludeCompileBeforeLaunchOption() || configuration instanceof RunConfigurationBase && ((RunConfigurationBase)configuration).excludeCompileBeforeLaunchOption()) {
            return true;
        }
        Ref result = new Ref((Object)Boolean.FALSE);
        try {
            Semaphore done = new Semaphore();
            done.down();
            TransactionGuard.submitTransaction((Disposable)myProject, () -> {
                Object projectTask;
                Object sessionId = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)env);
                ProjectTaskManager projectTaskManager = ProjectTaskManager.getInstance((Project)myProject);
                if (forceMakeProject) {
                    projectTask = projectTaskManager.createAllModulesBuildTask(true, myProject);
                } else {
                    Module[] modules = runConfiguration.getModules();
                    if (modules.length > 0) {
                        for (Module module2 : modules) {
                            if (module2 != null) continue;
                            LOG.error("RunConfiguration should not return null modules. Configuration=" + runConfiguration.getName() + "; class=" + runConfiguration.getClass().getName());
                        }
                        projectTask = projectTaskManager.createModulesBuildTask(modules, true, true, true);
                    } else {
                        projectTask = runConfiguration.isBuildProjectOnEmptyModuleList() ? projectTaskManager.createAllModulesBuildTask(true, myProject) : new EmptyCompileScopeBuildTaskImpl(true);
                    }
                }
                if (!myProject.isDisposed()) {
                    projectTaskManager.run(new ProjectTaskContext(sessionId, configuration), projectTask, executionResult -> {
                        if ((executionResult.getErrors() == 0 || ignoreErrors) && !executionResult.isAborted()) {
                            result.set((Object)Boolean.TRUE);
                        }
                        done.up();
                    });
                } else {
                    done.up();
                }
            });
            done.waitFor();
        }
        catch (Exception e) {
            return false;
        }
        return (Boolean)result.get();
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileContext context) {
        return CompileStepBeforeRun.getRunConfiguration(context.getCompileScope());
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileScope compileScope) {
        return (RunConfiguration)compileScope.getUserData(CompilerManager.RUN_CONFIGURATION_KEY);
    }

    public static class MakeBeforeRunTask
    extends BeforeRunTask<MakeBeforeRunTask> {
        public MakeBeforeRunTask() {
            super(ID);
            this.setEnabled(true);
        }
    }
}

