/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.impl.rmiCompiler.RmicConfiguration;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.RmicCompilerOptions;

public class RmicConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JCheckBox myCbEnabled;
    private JCheckBox myCbGenerateIiopStubs;
    private JCheckBox myCbDebuggingInfo;
    private JCheckBox myCbGenerateNoWarnings;
    private RawCommandLineEditor myAdditionalOptionsField;
    private final RmicCompilerOptions myRmicSettings;
    private final Project myProject;
    private JLabel myFieldLabel;

    public RmicConfigurable(Project project2) {
        this.$$$setupUI$$$();
        this.myRmicSettings = RmicConfiguration.getOptions(project2);
        this.myProject = project2;
        this.myCbEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RmicConfigurable.this.setOptionsEnabled(e.getStateChange() == 1);
            }
        });
        this.myAdditionalOptionsField.setDialogCaption(this.myFieldLabel.getText());
    }

    private void setOptionsEnabled(boolean selected) {
        this.myCbGenerateIiopStubs.setEnabled(selected);
        this.myCbGenerateNoWarnings.setEnabled(selected);
        this.myCbDebuggingInfo.setEnabled(selected);
        this.myFieldLabel.setEnabled(selected);
        this.myAdditionalOptionsField.setEnabled(selected);
    }

    public String getDisplayName() {
        return CompilerBundle.message((String)"rmi.compiler.description", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.rmicompiler";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        boolean isModified = false;
        isModified |= ComparingUtils.isModified(this.myCbEnabled, this.myRmicSettings.IS_EANABLED);
        isModified |= ComparingUtils.isModified(this.myCbGenerateIiopStubs, this.myRmicSettings.GENERATE_IIOP_STUBS);
        isModified |= ComparingUtils.isModified(this.myCbDebuggingInfo, this.myRmicSettings.DEBUGGING_INFO);
        isModified |= ComparingUtils.isModified(this.myCbGenerateNoWarnings, this.myRmicSettings.GENERATE_NO_WARNINGS);
        return isModified |= ComparingUtils.isModified(this.myAdditionalOptionsField, this.myRmicSettings.ADDITIONAL_OPTIONS_STRING);
    }

    public void apply() throws ConfigurationException {
        try {
            this.myRmicSettings.IS_EANABLED = this.myCbEnabled.isSelected();
            this.myRmicSettings.GENERATE_IIOP_STUBS = this.myCbGenerateIiopStubs.isSelected();
            this.myRmicSettings.DEBUGGING_INFO = this.myCbDebuggingInfo.isSelected();
            this.myRmicSettings.GENERATE_NO_WARNINGS = this.myCbGenerateNoWarnings.isSelected();
            this.myRmicSettings.ADDITIONAL_OPTIONS_STRING = this.myAdditionalOptionsField.getText();
        }
        finally {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public void reset() {
        this.myCbEnabled.setSelected(this.myRmicSettings.IS_EANABLED);
        this.setOptionsEnabled(this.myRmicSettings.IS_EANABLED);
        this.myCbGenerateIiopStubs.setSelected(this.myRmicSettings.GENERATE_IIOP_STUBS);
        this.myCbDebuggingInfo.setSelected(this.myRmicSettings.DEBUGGING_INFO);
        this.myCbGenerateNoWarnings.setSelected(this.myRmicSettings.GENERATE_NO_WARNINGS);
        this.myAdditionalOptionsField.setText(this.myRmicSettings.ADDITIONAL_OPTIONS_STRING);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myCbEnabled = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/CompilerBundle").getString("rmic.option.enable.rmi.stubs"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateIiopStubs = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CompilerBundle").getString("rmic.option.generate.iiop.stubs"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbDebuggingInfo = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.generate.debugging.info"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateNoWarnings = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.generate.no.warnings"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(10, 8, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myFieldLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.additional.command.line.parameters"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

