/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;

@ChannelHandler.Sharable
class BuildMessageDispatcher
extends SimpleChannelInboundHandlerAdapter<CmdlineRemoteProto.Message> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.BuildMessageDispatcher");
    private static final AttributeKey<SessionData> SESSION_DATA = AttributeKey.valueOf((String)"BuildMessageDispatcher.sessionData");
    private final Map<UUID, SessionData> mySessionDescriptors = new ConcurrentHashMap<UUID, SessionData>(16, 0.75f, 1);
    private final Set<UUID> myCanceledSessions = ContainerUtil.newConcurrentSet();

    BuildMessageDispatcher() {
    }

    public void registerBuildMessageHandler(final @NotNull RequestFuture<? extends BuilderMessageHandler> future, @Nullable CmdlineRemoteProto.Message.ControllerMessage params) {
        DelegatingMessageHandler wrappedHandler = new DelegatingMessageHandler(){

            @Override
            protected BuilderMessageHandler getDelegateHandler() {
                return (BuilderMessageHandler)future.getMessageHandler();
            }

            @Override
            public void sessionTerminated(@NotNull UUID sessionId) {
                try {
                    super.sessionTerminated(sessionId);
                }
                finally {
                    future.setDone();
                }
            }
        };
        UUID sessionId = future.getRequestID();
        this.mySessionDescriptors.put(sessionId, new SessionData(sessionId, wrappedHandler, params));
    }

    @Nullable
    public BuilderMessageHandler unregisterBuildMessageHandler(UUID sessionId) {
        this.myCanceledSessions.remove(sessionId);
        SessionData data = this.mySessionDescriptors.remove(sessionId);
        if (data == null) {
            return null;
        }
        Channel channel = data.channel;
        if (channel != null) {
            channel.attr(SESSION_DATA).set(null);
        }
        return data.handler;
    }

    public void cancelSession(UUID sessionId) {
        Channel channel;
        if (this.myCanceledSessions.add(sessionId) && (channel = this.getConnectedChannel(sessionId)) != null) {
            channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
        }
    }

    @Nullable
    public Channel getConnectedChannel(@NotNull UUID sessionId) {
        Channel channel = this.getAssociatedChannel(sessionId);
        return channel != null && channel.isActive() ? channel : null;
    }

    @Nullable
    public Channel getAssociatedChannel(@NotNull UUID sessionId) {
        SessionData data = this.mySessionDescriptors.get(sessionId);
        return data != null ? data.channel : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBuildParameters(@NotNull UUID preloadedSessionId, @NotNull CmdlineRemoteProto.Message.ControllerMessage params) {
        boolean succeeded = false;
        SessionData sessionData = this.mySessionDescriptors.get(preloadedSessionId);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (sessionData.state == SessionData.State.WAITING_PARAMS) {
                    sessionData.state = SessionData.State.RUNNING;
                    Channel channel = sessionData.channel;
                    if (channel != null && channel.isActive()) {
                        sessionData.handler.buildStarted(preloadedSessionId);
                        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)preloadedSessionId, (CmdlineRemoteProto.Message.ControllerMessage)params));
                        succeeded = true;
                    }
                } else if (sessionData.state == SessionData.State.INITIAL) {
                    sessionData.params = params;
                    succeeded = true;
                }
            }
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void messageReceived(ChannelHandlerContext context, CmdlineRemoteProto.Message message) {
        UUID sessionId;
        boolean isFirstMessage;
        SessionData sessionData = (SessionData)context.channel().attr(SESSION_DATA).get();
        boolean bl = isFirstMessage = sessionData == null;
        if (isFirstMessage) {
            CmdlineRemoteProto.Message.UUID id = message.getSessionId();
            sessionId = new UUID(id.getMostSigBits(), id.getLeastSigBits());
            sessionData = this.mySessionDescriptors.get(sessionId);
            if (sessionData != null) {
                sessionData.channel = context.channel();
                context.channel().attr(SESSION_DATA).set((Object)sessionData);
            }
        } else {
            sessionId = sessionData.sessionId;
        }
        BuilderMessageHandler handler = sessionData != null ? sessionData.handler : null;
        try {
            if (handler == null) {
                if (BuildMessageDispatcher.isBuilderEvent(message)) return;
                LOG.info("No message handler registered for session " + sessionId);
                return;
            }
            CmdlineRemoteProto.Message.Type messageType = message.getType();
            switch (messageType) {
                case FAILURE: {
                    handler.handleFailure(sessionId, message.getFailure());
                    return;
                }
                case BUILDER_MESSAGE: {
                    CmdlineRemoteProto.Message.BuilderMessage builderMessage = message.getBuilderMessage();
                    CmdlineRemoteProto.Message.BuilderMessage.Type msgType = builderMessage.getType();
                    if (msgType == CmdlineRemoteProto.Message.BuilderMessage.Type.PARAM_REQUEST) {
                        SessionData sessionData2 = sessionData;
                        synchronized (sessionData2) {
                            CmdlineRemoteProto.Message.ControllerMessage params = sessionData.params;
                            if (params != null) {
                                sessionData.state = SessionData.State.RUNNING;
                                handler.buildStarted(sessionId);
                                sessionData.params = null;
                                context.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)params));
                            } else if (sessionData.state == SessionData.State.INITIAL) {
                                sessionData.state = SessionData.State.WAITING_PARAMS;
                            } else {
                                this.cancelSession(sessionId);
                            }
                            return;
                        }
                    }
                    handler.handleBuildMessage(context.channel(), sessionId, builderMessage);
                    return;
                }
                default: {
                    LOG.info("Unsupported message type " + messageType);
                    return;
                }
            }
        }
        finally {
            if (isFirstMessage && this.myCanceledSessions.contains(sessionId) || handler == null && !BuildMessageDispatcher.isBuilderEvent(message)) {
                context.channel().writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
            }
        }
    }

    private static boolean isBuilderEvent(CmdlineRemoteProto.Message message) {
        return message.hasBuilderMessage() && message.getBuilderMessage().getType() == CmdlineRemoteProto.Message.BuilderMessage.Type.BUILD_EVENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        BuilderMessageHandler handler;
        try {
            super.channelInactive(context);
        }
        catch (Throwable throwable) {
            BuilderMessageHandler handler2;
            SessionData sessionData = (SessionData)context.channel().attr(SESSION_DATA).get();
            if (sessionData != null && (handler2 = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
                handler2.sessionTerminated(sessionData.sessionId);
            }
            throw throwable;
        }
        SessionData sessionData = (SessionData)context.channel().attr(SESSION_DATA).get();
        if (sessionData != null && (handler = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
            handler.sessionTerminated(sessionData.sessionId);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        if (cause != null) {
            LOG.info(cause);
        }
    }

    private static final class SessionData {
        @NotNull
        final UUID sessionId;
        @NotNull
        final BuilderMessageHandler handler;
        volatile CmdlineRemoteProto.Message.ControllerMessage params;
        volatile Channel channel;
        State state = State.INITIAL;

        private SessionData(@NotNull UUID sessionId, @NotNull BuilderMessageHandler handler, CmdlineRemoteProto.Message.ControllerMessage params) {
            this.sessionId = sessionId;
            this.handler = handler;
            this.params = params;
        }

        static enum State {
            INITIAL,
            WAITING_PARAMS,
            RUNNING;

        }
    }
}

