/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="BuildProcessPlugins", storages={@Storage(value="compiler.xml")})
public class BuildProcessCustomPluginsConfiguration
implements PersistentStateComponent<BuildProcessPluginsState> {
    private static final Logger LOG = Logger.getInstance(BuildProcessCustomPluginsConfiguration.class);
    private final BuildProcessPluginsState myState = new BuildProcessPluginsState();
    private final Project myProject;

    public BuildProcessCustomPluginsConfiguration(Project project2) {
        this.myProject = project2;
    }

    public static BuildProcessCustomPluginsConfiguration getInstance(@NotNull Project project2) {
        return (BuildProcessCustomPluginsConfiguration)ServiceManager.getService((Project)project2, BuildProcessCustomPluginsConfiguration.class);
    }

    public List<String> getProjectLibraries() {
        return this.myState.myProjectLibraries;
    }

    public List<String> getCustomPluginsClasspath() {
        return (List)ReadAction.compute(() -> {
            ArrayList<String> result = new ArrayList<String>();
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
            for (String libraryName : this.myState.myProjectLibraries) {
                Library library = libraryTable.getLibraryByName(libraryName);
                if (library == null) {
                    LOG.warn("Unknown project library in BuildProcessCustomPluginsConfiguration: " + libraryName);
                    continue;
                }
                for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                    result.add(VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath());
                }
            }
            return result;
        });
    }

    @Nullable
    public BuildProcessPluginsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull BuildProcessPluginsState state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    public static class BuildProcessPluginsState {
        @Property(surroundWithTag=false)
        @XCollection(elementName="project-library", valueAttributeName="name", style=XCollection.Style.v2)
        public List<String> myProjectLibraries = new ArrayList<String>();
    }
}

